; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - GRAPHIC.prg
; -------------------------------------------------------------------------------------------------------------- ;
;                        * equ $1e00
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
;                        incdir  ..\inc              ; C64 System Includes
;
;C64CIA1                 include cia1.asm            ; Complex Interface Adapter (CIA) #1 Registers  $DC00-$DC0F
;C64CIA2                 include cia2.asm            ; Complex Interface Adapter (CIA) #2 Registers  $DD00-$DD0F
;C64SID                  include sid.asm             ; Sound Interface Device (SID) Registers        $D400-$D41C
;C64VicII                include vic.asm             ; Video Interface Chip (VIC-II) Registers       $D000-$D02E
;C64Kernel               include kernel.asm          ; Kernel Vectors
;C64Colors               include color.asm           ; Colour RAM Address / Colours
;C64Memory               include mem.asm             ; Memory Layout
;
;Game                    include inc\BH_Game.asm     ; Game Variables
;Externals               include inc\BH_Externals.asm; Subroutines and Tables
;ZeroPage                include inc\BH_Zpg.asm      ; Zero Page Addresses
;
;Equates                 include inc\BL_Equates.asm  ; External and Unresolved Addresses
; -------------------------------------------------------------------------------------------------------------- ;
TabScrnRowPtrLo         dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $00)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $01)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $02)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $03)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $04)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $05)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $06)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $07)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $08)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $09)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $0a)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $0b)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $0c)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $0d)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $0e)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $0f)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $10)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $11)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $12)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $13)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $14)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $15)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $16)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $17)] ; 
                        dc.b <[BH_Scrn_Gfx   + (BH_Scrn_Gfx_RowLen * $18)] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScrnRowPtrGfxAHi     dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $00)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $01)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $02)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $03)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $04)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $05)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $06)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $07)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $08)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $09)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $0a)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $0b)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $0c)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $0d)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $0e)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $0f)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $10)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $11)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $12)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $13)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $14)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $15)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $16)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $17)] ; 
                        dc.b >[BH_Scrn_Gfx_A + (BH_Scrn_Gfx_RowLen * $18)] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScrnRowPtrGfxBHi     dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $00)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $01)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $02)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $03)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $04)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $05)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $06)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $07)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $08)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $09)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $0a)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $0b)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $0c)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $0d)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $0e)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $0f)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $10)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $11)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $12)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $13)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $14)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $15)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $16)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $17)] ; 
                        dc.b >[BH_Scrn_Gfx_B + (BH_Scrn_Gfx_RowLen * $18)] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScrnRowPtrSaveHi     dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $00)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $01)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $02)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $03)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $04)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $05)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $06)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $07)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $08)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $09)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $0a)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $0b)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $0c)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $0d)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $0e)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $0f)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $10)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $11)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $12)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $13)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $14)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $15)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $16)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $17)] ; 
                        dc.b >[BH_Scrn_Gfx_Save + (BH_Scrn_Gfx_RowLen * $18)] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScrnRowPtrColoRamHi  dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $00)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $01)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $02)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $03)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $04)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $05)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $06)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $07)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $08)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $09)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $0a)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $0b)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $0c)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $0d)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $0e)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $0f)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $10)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $11)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $12)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $13)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $14)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $15)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $16)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $17)] ; 
                        dc.b >[COLORAM + (BH_Scrn_Gfx_RowLen * $18)] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Tank screen graphics data
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $b4 ; 
                        dc.b $b4 ; 
                        dc.b $b4 ; 
A_9880                  dc.b $b4 ; 
                        dc.b $b4 ; 
                        dc.b $b4 ; 
                        dc.b $b4 ; 
                        dc.b $b5 ; 
                        dc.b $b5 ; 
                        dc.b $b5 ; 
                        dc.b $b5 ; 
                        dc.b $b5 ; 
                        dc.b $b5 ; 
                        dc.b $b6 ; 
                        dc.b $b6 ; 
                        dc.b $b6 ; 
                        dc.b $b6 ; 
                        dc.b $b6 ; 
                        dc.b $b6 ; 
A_9890                  dc.b $b6 ; 
                        dc.b $b7 ; 
                        dc.b $b7 ; 
                        dc.b $b7 ; 
                        dc.b $b7 ; 
                        dc.b $b7 ; 
                        dc.b $ff ; 
                        dc.b $bf ; 
                        dc.b $a7 ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $f4 ; 
A_98a0                  dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
A_98b0                  dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $7f ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $c0 ; 
                        dc.b $ff ; 
A_98c0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_98d0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_98e0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_98f0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; 256 pointers to char/color data for 256 screen scroll lines - PosX (PosY set in the addressed struct)
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaPtrLo  equ  *       ; 
                        dc.b <T_b3b2 ; - screen_0 - finish - foot of hill
                        dc.b <T_b3c4 ; 
                        dc.b <T_b3d3 ; 
                        dc.b <T_b3e2 ; 
                        dc.b <$0000  ; - simple strand
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        dc.b <$0000  ; 
                        
A_9910                  dc.b <$0000  ; $00 - screen_05
                        dc.b <$0000  ; $01
                        dc.b <$0000  ; $02
                        dc.b <$0000  ; $03
                        dc.b <$0000  ; $04
                        dc.b <$0000  ; $05
                        dc.b <$0000  ; $06
                        dc.b <$0000  ; $07
                        dc.b <$0000  ; $08
                        dc.b <$0000  ; $09
                        dc.b <$0000  ; $0a
                        dc.b <$0000  ; $0b
                        dc.b <$0000  ; $0c
                        dc.b <$0000  ; $0d
                        dc.b <$0000  ; $0e
                        dc.b <$0000  ; $1f
A_9920                  dc.b <$0000  ; $10
                        dc.b <$0000  ; $11
                        dc.b <$0000  ; $12
                        dc.b <T_b3e8 ; $13
                        dc.b <T_b3ee ; $14
                        dc.b <T_b40c ; $15
                        dc.b <T_b42d ; $16
                        dc.b <T_b442 ; $17
                        dc.b <$0000  ; $18
                        dc.b <$0000  ; $19
                        dc.b <T_b44e ; $1a
                        dc.b <$0000  ; $1b
                        dc.b <T_b451 ; $1c
                        dc.b <T_b457 ; $1d
                        dc.b <$0000  ; $1e
                        dc.b <T_b45a ; $1f
A_9930                  dc.b <T_b460 ; $20
                        dc.b <$0000  ; $21
                        dc.b <$0000  ; $22
                        dc.b <T_b463 ; $23
                        dc.b <$0000  ; $24
                        dc.b <T_b466 ; $25
                        dc.b <$0000  ; $26
                        dc.b <$0000  ; $27
                        
                        dc.b <T_b469 ; $00 - screen_04
                        dc.b <T_b46f ; $01
                        dc.b <T_b478 ; $02
                        dc.b <$0000  ; $03
                        dc.b <T_b47e ; $04
                        dc.b <$0000  ; $05
                        dc.b <T_b481 ; $06
                        dc.b <$0000  ; $07
A_9940                  dc.b <$0000  ; $08
                        dc.b <T_b484 ; $09
                        dc.b <T_b490 ; $0a
                        dc.b <T_b49c ; $0b
                        dc.b <$0000  ; $0c
                        dc.b <T_b4a8 ; $0d
                        dc.b <T_b4b4 ; $0e
                        dc.b <T_b4c0 ; $1f
                        dc.b <T_b4db ; $10
                        dc.b <T_b4e7 ; $11
                        dc.b <T_b4f3 ; $12
                        dc.b <T_b4ff ; $13
                        dc.b <T_b50b ; $14
                        dc.b <T_b526 ; $15
                        dc.b <T_b532 ; $16
                        dc.b <$0000  ; $17
A_9950                  dc.b <T_b53e ; $18
                        dc.b <T_b54a ; $19
                        dc.b <T_b556 ; $1a
                        dc.b <$0000  ; $1b
                        dc.b <T_b562 ; $1c
                        dc.b <$0000  ; $1d
                        dc.b <$0000  ; $1e
                        dc.b <$0000  ; $1f
                        dc.b <$0000  ; $20
                        dc.b <$0000  ; $21
                        dc.b <T_b568 ; $22
                        dc.b <T_b56e ; $23
                        dc.b <$0000  ; $24
                        dc.b <$0000  ; $25
                        dc.b <$0000  ; $26
                        dc.b <$0000  ; $27
                        
A_9960                  dc.b <$0000  ; $00 - screen_03
                        dc.b <T_b571 ; $01
                        dc.b <$0000  ; $02
                        dc.b <$0000  ; $03
                        dc.b <$0000  ; $04
                        dc.b <T_b577 ; $05
                        dc.b <T_b583 ; $06
                        dc.b <T_b58f ; $07
                        dc.b <T_b59b ; $08
                        dc.b <T_b5a7 ; $09
                        dc.b <T_b5b3 ; $0a
                        dc.b <$0000  ; $0b
                        dc.b <$0000  ; $0c
                        dc.b <T_b5bf ; $0d
                        dc.b <$0000  ; $0e
                        dc.b <$0000  ; $1f
A_9970                  dc.b <$0000  ; $10
                        dc.b <$0000  ; $11
                        dc.b <$0000  ; $12
                        dc.b <T_b5c8 ; $13
                        dc.b <T_b5cb ; $14
                        dc.b <T_b5d7 ; $15
                        dc.b <$0000  ; $16
                        dc.b <$0000  ; $17
                        dc.b <$0000  ; $18
                        dc.b <$0000  ; $19
                        dc.b <T_b5dd ; $1a
                        dc.b <T_b5e9 ; $1b
                        dc.b <$0000  ; $1c
                        dc.b <$0000  ; $1d
                        dc.b <$0000  ; $1e
                        dc.b <$0000  ; $1f
A_9980                  dc.b <T_b5ec ; $20
                        dc.b <T_b5f8 ; $21
                        dc.b <T_b60a ; $22
                        dc.b <$0000  ; $23
                        dc.b <$0000  ; $24
                        dc.b <$0000  ; $25
                        dc.b <$0000  ; $26
                        dc.b <$0000  ; $27
                        
                        dc.b <T_b619 ; $00 - screen_02
                        dc.b <T_b61c ; $01
                        dc.b <T_b622 ; $02
                        dc.b <T_b628 ; $03
                        dc.b <$0000  ; $04
                        dc.b <T_b62e ; $05
                        dc.b <T_b631 ; $06
                        dc.b <T_b637 ; $07
A_9990                  dc.b <$0000  ; $08
                        dc.b <T_b63a ; $09
                        dc.b <T_b640 ; $0a
                        dc.b <T_b649 ; $0b
                        dc.b <$0000  ; $0c
                        dc.b <$0000  ; $0d
                        dc.b <T_b64f ; $0e
                        dc.b <T_b652 ; $1f
                        dc.b <$0000  ; $10
                        dc.b <$0000  ; $11
                        dc.b <$0000  ; $12
                        dc.b <$0000  ; $13
                        dc.b <T_b655 ; $14
                        dc.b <T_b65b ; $15
                        dc.b <T_b679 ; $16
                        dc.b <T_b69a ; $17
A_99a0                  dc.b <T_b6af ; $18
                        dc.b <$0000  ; $19
                        dc.b <$0000  ; $1a
                        dc.b <$0000  ; $1b
                        dc.b <T_b6bb ; $1c
                        dc.b <$0000  ; $1d
                        dc.b <$0000  ; $1e
                        dc.b <T_b6be ; $1f
                        dc.b <T_b6c1 ; $20
                        dc.b <T_b6c7 ; $21
                        dc.b <T_b6ca ; $22
                        dc.b <T_b6d0 ; $23
                        dc.b <T_b6d6 ; $24
                        dc.b <T_b6dc ; $25
                        dc.b <$0000  ; $26
                        dc.b <$0000  ; $27
                        
A_99b0                  dc.b <$0000  ; $00 - screen_01
                        dc.b <T_b6df ; $01
                        dc.b <T_b6e5 ; $02
                        dc.b <T_b6eb ; $03
                        dc.b <$0000  ; $04
                        dc.b <T_b6f4 ; $05
                        dc.b <T_b6fa ; $06
                        dc.b <$0000  ; $07
                        dc.b <$0000  ; $08
                        dc.b <$0000  ; $09
                        dc.b <$0000  ; $0a
                        dc.b <$0000  ; $0b
                        dc.b <T_b6fd ; $0c
                        dc.b <T_b703 ; $0d
                        dc.b <T_b70c ; $0e
                        dc.b <$0000  ; $1f
A_99c0                  dc.b <$0000  ; $10
                        dc.b <$0000  ; $11
                        dc.b <T_b715 ; $12
                        dc.b <T_b71b ; $13
                        dc.b <T_b724 ; $14
                        dc.b <T_b72a ; $15
                        dc.b <$0000  ; $16
                        dc.b <$0000  ; $17
                        dc.b <$0000  ; $18
                        dc.b <$0000  ; $19
                        dc.b <$0000  ; $1a
                        dc.b <$0000  ; $1b
                        dc.b <$0000  ; $1c
                        dc.b <T_b72d ; $1d
                        dc.b <T_b739 ; $1e
                        dc.b <T_b745 ; $1f
A_99d0                  dc.b <T_b751 ; $20
                        dc.b <T_b75a ; $21
                        dc.b <$0000  ; $22
                        dc.b <$0000  ; $23
                        dc.b <$0000  ; $24
                        dc.b <T_b75d ; $25
                        dc.b <$0000  ; $26
                        dc.b <$0000  ; $27
                        
                        dc.b <$0000  ; $00 - screen_00 - start
                        dc.b <$0000  ; $01
                        dc.b <$0000  ; $02
                        dc.b <$0000  ; $03
                        dc.b <$0000  ; $04
                        dc.b <$0000  ; $05
                        dc.b <$0000  ; $06
                        dc.b <$0000  ; $07
A_99e0                  dc.b <$0000  ; $08
                        dc.b <$0000  ; $09
                        dc.b <$0000  ; $0a
                        dc.b <$0000  ; $0b
                        dc.b <$0000  ; $0c
                        dc.b <$0000  ; $0d
                        dc.b <$0000  ; $0e
                        dc.b <$0000  ; $1f
                        dc.b <$0000  ; $10
                        dc.b <$0000  ; $11
                        dc.b <$0000  ; $12
                        dc.b <$0000  ; $13
                        dc.b <$0000  ; $14
                        dc.b <$0000  ; $15
                        dc.b <$0000  ; $16
                        dc.b <$0000  ; $17
A_99f0                  dc.b <$0000  ; $18
                        dc.b <$0000  ; $19
                        dc.b <$0000  ; $1a
                        dc.b <$0000  ; $1b
                        dc.b <T_b760 ; $1c - shore
                        dc.b <T_b769 ; $1d
                        dc.b <T_b778 ; $1e
                        dc.b <T_b793 ; $1f $f7
                        dc.b <T_b7ab ; $20
                        dc.b <T_b7cc ; $21
                        dc.b <T_b7ed ; $22
                        dc.b <T_b80e ; $23
                        dc.b <T_b835 ; $24
                        dc.b <T_b85f ; $25
                        dc.b <T_b88c ; $26
                        dc.b <T_b8b9 ; $27
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaPtrHi  equ  *       ; 
                        dc.b >T_b3b2 ;  - screen_06 - finish - foot of hill
                        dc.b >T_b3c4 ; 
                        dc.b >T_b3d3 ; 
                        dc.b >T_b3e2 ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        dc.b >$0000  ; 
                        
A_9a10                  dc.b >$0000  ; $00 - screen_05
                        dc.b >$0000  ; $01
                        dc.b >$0000  ; $02
                        dc.b >$0000  ; $03
                        dc.b >$0000  ; $04
                        dc.b >$0000  ; $05
                        dc.b >$0000  ; $06
                        dc.b >$0000  ; $07
                        dc.b >$0000  ; $08
                        dc.b >$0000  ; $09
                        dc.b >$0000  ; $0a
                        dc.b >$0000  ; $0b
                        dc.b >$0000  ; $0c
                        dc.b >$0000  ; $0d
                        dc.b >$0000  ; $0e
                        dc.b >$0000  ; $1f
A_9a20                  dc.b >$0000  ; $10
                        dc.b >$0000  ; $11
                        dc.b >$0000  ; $12
                        dc.b >T_b3e8 ; $13
                        dc.b >T_b3ee ; $14
                        dc.b >T_b40c ; $15
                        dc.b >T_b42d ; $16
                        dc.b >T_b442 ; $17
                        dc.b >$0000  ; $18
                        dc.b >$0000  ; $19
                        dc.b >T_b44e ; $1a
                        dc.b >$0000  ; $1b
                        dc.b >T_b451 ; $1c
                        dc.b >T_b457 ; $1d
                        dc.b >$0000  ; $1e
                        dc.b >T_b45a ; $1f
A_9a30                  dc.b >T_b460 ; $20
                        dc.b >$0000  ; $21
                        dc.b >$0000  ; $22
                        dc.b >T_b463 ; $23
                        dc.b >$0000  ; $24
                        dc.b >T_b466 ; $25
                        dc.b >$0000  ; $26
                        dc.b >$0000  ; $27
                        
                        dc.b >T_b469 ; $00 - screen_04
                        dc.b >T_b46f ; $01
                        dc.b >T_b478 ; $02
                        dc.b >$0000  ; $03
                        dc.b >T_b47e ; $04
                        dc.b >$0000  ; $05
                        dc.b >T_b481 ; $06
                        dc.b >$0000  ; $07
A_9a40                  dc.b >$0000  ; $08
                        dc.b >T_b484 ; $09
                        dc.b >T_b490 ; $0a
                        dc.b >T_b49c ; $0b
                        dc.b >$0000  ; $0c
                        dc.b >T_b4a8 ; $0d
                        dc.b >T_b4b4 ; $0e
                        dc.b >T_b4c0 ; $1f
                        dc.b >T_b4db ; $10
                        dc.b >T_b4e7 ; $11
                        dc.b >T_b4f3 ; $12
                        dc.b >T_b4ff ; $13
                        dc.b >T_b50b ; $14
                        dc.b >T_b526 ; $15
                        dc.b >T_b532 ; $16
                        dc.b >$0000  ; $17
A_9a50                  dc.b >T_b53e ; $18
                        dc.b >T_b54a ; $19
                        dc.b >T_b556 ; $1a
                        dc.b >$0000  ; $1b
                        dc.b >T_b562 ; $1c
                        dc.b >$0000  ; $1d
                        dc.b >$0000  ; $1e
                        dc.b >$0000  ; $1f
                        dc.b >$0000  ; $20
                        dc.b >$0000  ; $21
                        dc.b >T_b568 ; $22
                        dc.b >T_b56e ; $23
                        dc.b >$0000  ; $24
                        dc.b >$0000  ; $25
                        dc.b >$0000  ; $26
                        dc.b >$0000  ; $27
                        
A_9a60                  dc.b >$0000  ; $00 - screen_03
                        dc.b >T_b571 ; $01
                        dc.b >$0000  ; $02
                        dc.b >$0000  ; $03
                        dc.b >$0000  ; $04
                        dc.b >T_b577 ; $05
                        dc.b >T_b583 ; $06
                        dc.b >T_b58f ; $07
                        dc.b >T_b59b ; $08
                        dc.b >T_b5a7 ; $09
                        dc.b >T_b5b3 ; $0a
                        dc.b >$0000  ; $0b
                        dc.b >$0000  ; $0c
                        dc.b >T_b5bf ; $0d
                        dc.b >$0000  ; $0e
                        dc.b >$0000  ; $1f
A_9a70                  dc.b >$0000  ; $10
                        dc.b >$0000  ; $11
                        dc.b >$0000  ; $12
                        dc.b >T_b5c8 ; $13
                        dc.b >T_b5cb ; $14
                        dc.b >T_b5d7 ; $15
                        dc.b >$0000  ; $16
                        dc.b >$0000  ; $17
                        dc.b >$0000  ; $18
                        dc.b >$0000  ; $19
                        dc.b >T_b5dd ; $1a
                        dc.b >T_b5e9 ; $1b
                        dc.b >$0000  ; $1c
                        dc.b >$0000  ; $1d
                        dc.b >$0000  ; $1e
                        dc.b >$0000  ; $1f
A_9a80                  dc.b >T_b5ec ; $20
                        dc.b >T_b5f8 ; $21
                        dc.b >T_b60a ; $22
                        dc.b >$0000  ; $23
                        dc.b >$0000  ; $24
                        dc.b >$0000  ; $25
                        dc.b >$0000  ; $26
                        dc.b >$0000  ; $27
                        
                        dc.b >T_b619 ; $00 - screen_02
                        dc.b >T_b61c ; $01
                        dc.b >T_b622 ; $02
                        dc.b >T_b628 ; $03
                        dc.b >$0000  ; $04
                        dc.b >T_b62e ; $05
                        dc.b >T_b631 ; $06
                        dc.b >T_b637 ; $07
A_9a90                  dc.b >$0000  ; $08
                        dc.b >T_b63a ; $09
                        dc.b >T_b640 ; $0a
                        dc.b >T_b649 ; $0b
                        dc.b >$0000  ; $0c
                        dc.b >$0000  ; $0d
                        dc.b >T_b64f ; $0e
                        dc.b >T_b652 ; $1f
                        dc.b >$0000  ; $10
                        dc.b >$0000  ; $11
                        dc.b >$0000  ; $12
                        dc.b >$0000  ; $13
                        dc.b >T_b655 ; $14
                        dc.b >T_b65b ; $15
                        dc.b >T_b679 ; $16
                        dc.b >T_b69a ; $17
A_9aa0                  dc.b >T_b6af ; $18
                        dc.b >$0000  ; $19
                        dc.b >$0000  ; $1a
                        dc.b >$0000  ; $1b
                        dc.b >T_b6bb ; $1c
                        dc.b >$0000  ; $1d
                        dc.b >$0000  ; $1e
                        dc.b >T_b6be ; $1f
                        dc.b >T_b6c1 ; $20
                        dc.b >T_b6c7 ; $21
                        dc.b >T_b6ca ; $22
                        dc.b >T_b6d0 ; $23
                        dc.b >T_b6d6 ; $24
                        dc.b >T_b6dc ; $25
                        dc.b >$0000  ; $26
                        dc.b >$0000  ; $27
                        
A_9ab0                  dc.b >$0000  ; $00 - screen_01
                        dc.b >T_b6df ; $01
                        dc.b >T_b6e5 ; $02
                        dc.b >T_b6eb ; $03
                        dc.b >$0000  ; $04
                        dc.b >T_b6f4 ; $05
                        dc.b >T_b6fa ; $06
                        dc.b >$0000  ; $07
                        dc.b >$0000  ; $08
                        dc.b >$0000  ; $09
                        dc.b >$0000  ; $0a
                        dc.b >$0000  ; $0b
                        dc.b >T_b6fd ; $0c
                        dc.b >T_b703 ; $0d
                        dc.b >T_b70c ; $0e
                        dc.b >$0000  ; $1f
A_9ac0                  dc.b >$0000  ; $10
                        dc.b >$0000  ; $11
                        dc.b >T_b715 ; $12
                        dc.b >T_b71b ; $13
                        dc.b >T_b724 ; $14
                        dc.b >T_b72a ; $15
                        dc.b >$0000  ; $16
                        dc.b >$0000  ; $17
                        dc.b >$0000  ; $18
                        dc.b >$0000  ; $19
                        dc.b >$0000  ; $1a
                        dc.b >$0000  ; $1b
                        dc.b >$0000  ; $1c
                        dc.b >T_b72d ; $1d
                        dc.b >T_b739 ; $1e
                        dc.b >T_b745 ; $1f
A_9ad0                  dc.b >T_b751 ; $20
                        dc.b >T_b75a ; $21
                        dc.b >$0000  ; $22
                        dc.b >$0000  ; $23
                        dc.b >$0000  ; $24
                        dc.b >T_b75d ; $25
                        dc.b >$0000  ; $26
                        dc.b >$0000  ; $27
                        
                        dc.b >$0000  ; $00 - screen_00 - start
                        dc.b >$0000  ; $01
                        dc.b >$0000  ; $02
                        dc.b >$0000  ; $03
                        dc.b >$0000  ; $04
                        dc.b >$0000  ; $05
                        dc.b >$0000  ; $06
                        dc.b >$0000  ; $07
A_9ae0                  dc.b >$0000  ; $08
                        dc.b >$0000  ; $09
                        dc.b >$0000  ; $0a
                        dc.b >$0000  ; $0b
                        dc.b >$0000  ; $0c
                        dc.b >$0000  ; $0d
                        dc.b >$0000  ; $0e
                        dc.b >$0000  ; $1f
                        dc.b >$0000  ; $10
                        dc.b >$0000  ; $11
                        dc.b >$0000  ; $12
                        dc.b >$0000  ; $13
                        dc.b >$0000  ; $14
                        dc.b >$0000  ; $15
                        dc.b >$0000  ; $16
                        dc.b >$0000  ; $17
A_9af0                  dc.b >$0000  ; $18
                        dc.b >$0000  ; $19
                        dc.b >$0000  ; $1a
                        dc.b >$0000  ; $1b
                        dc.b >T_b760 ; $1c - shore
                        dc.b >T_b769 ; $1d
                        dc.b >T_b778 ; $1e
                        dc.b >T_b793 ; $1f $f7
                        dc.b >T_b7ab ; $20
                        dc.b >T_b7cc ; $21
                        dc.b >T_b7ed ; $22
                        dc.b >T_b80e ; $23
                        dc.b >T_b835 ; $24
                        dc.b >T_b85f ; $25
                        dc.b >T_b88c ; $26
                        dc.b >T_b8b9 ; $27
; -------------------------------------------------------------------------------------------------------------- ;
; Bay map screen graphics data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataBayMap        equ  *   ; 
A_9b00                  dc.b $09 ; unused
                        dc.b BLUE ; --> TabBackGroundColor
                        dc.b $00 ; --> BGCOL1
                        dc.b $05 ; --> BGCOL2
                        dc.b $01 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
                        dc.b $02 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
                        dc.b $03 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $25 ; --> count
                        dc.b $98 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
A_9b10                  dc.b $04 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
                        dc.b $05 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
                        dc.b $06 ; --> screen $4800
                        dc.b $0f ; --> color  $d800
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $24 ; --> count
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $03 ; --> count
                        dc.b $07 ; 
                        dc.b $0f ; 
A_9b20                  dc.b $08 ; 
                        dc.b $0f ; 
                        dc.b $09 ; 
                        dc.b $0f ; 
                        dc.b $0a ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $21 ; --> count
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $06 ; --> count
                        dc.b $0b ; 
                        dc.b $0f ; 
A_9b30                  dc.b $0c ; 
                        dc.b $0f ; 
                        dc.b $0d ; 
                        dc.b $0f ; 
                        dc.b $0e ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $1e ; --> count
                        dc.b $0f ; 
                        dc.b $0f ; 
                        dc.b $10 ; 
                        dc.b $0f ; 
                        dc.b $11 ; 
                        dc.b $0f ; 
A_9b40                  dc.b $12 ; 
                        dc.b $0f ; 
                        dc.b $13 ; 
                        dc.b $0f ; 
                        dc.b $14 ; 
                        dc.b $0f ; 
                        dc.b $15 ; 
                        dc.b $0f ; 
                        dc.b $16 ; 
                        dc.b $0f ; 
                        dc.b $17 ; 
                        dc.b $0f ; 
                        dc.b $18 ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
A_9b50                  dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $26 ; --> count
                        dc.b $19 ; 
                        dc.b $0f ; 
                        dc.b $1a ; 
                        dc.b $0f ; 
                        dc.b $1b ; 
                        dc.b $0f ; 
                        dc.b $1c ; 
                        dc.b $0f ; 
                        dc.b $1d ; 
                        dc.b $0f ; 
                        dc.b $1e ; 
                        dc.b $0f ; 
                        dc.b $1f ; 
                        dc.b $0f ; 
A_9b60                  dc.b $20 ; 
                        dc.b $0f ; 
                        dc.b $21 ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $20 ; --> count
                        dc.b $22 ; 
                        dc.b $0f ; 
                        dc.b $23 ; 
                        dc.b $0f ; 
                        dc.b $24 ; 
                        dc.b $0f ; 
                        dc.b $25 ; 
                        dc.b $0f ; 
A_9b70                  dc.b $26 ; 
                        dc.b $0f ; 
                        dc.b $27 ; 
                        dc.b $0f ; 
                        dc.b $98 ; 
                        dc.b $0f ; 
                        dc.b $28 ; 
                        dc.b $0f ; 
                        dc.b $29 ; 
                        dc.b $0f ; 
                        dc.b $2a ; 
                        dc.b $0f ; 
                        dc.b $2b ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
A_9b80                  dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $22 ; --> count
                        dc.b $2c ; 
                        dc.b $0f ; 
                        dc.b $2d ; 
                        dc.b $0f ; 
                        dc.b $2e ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $2f ; 
                        dc.b $0f ; 
                        dc.b $30 ; 
                        dc.b $0f ; 
A_9b90                  dc.b $31 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $22 ; --> count
                        dc.b $32 ; 
                        dc.b $0f ; 
                        dc.b $33 ; 
                        dc.b $0f ; 
                        dc.b $34 ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
A_9ba0                  dc.b $35 ; 
                        dc.b $0f ; 
                        dc.b $36 ; 
                        dc.b $0f ; 
                        dc.b $37 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $21 ; --> count
                        dc.b $38 ; 
                        dc.b $07 ; 
                        dc.b $39 ; 
                        dc.b $0f ; 
                        dc.b $98 ; 
                        dc.b $0f ; 
A_9bb0                  dc.b $3a ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $3b ; 
                        dc.b $0f ; 
                        dc.b $3c ; 
                        dc.b $0f ; 
                        dc.b $3d ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $0e ; --> count
A_9bc0                  dc.b $63 ; 
                        dc.b $0f ; 
                        dc.b $64 ; 
                        dc.b $0f ; 
                        dc.b $65 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $0e ; --> count
                        dc.b $3e ; 
                        dc.b $07 ; 
                        dc.b $3f ; 
                        dc.b $07 ; 
                        dc.b $40 ; 
                        dc.b $07 ; 
A_9bd0                  dc.b $41 ; 
                        dc.b $07 ; 
                        dc.b $42 ; 
                        dc.b $0f ; 
                        dc.b $43 ; 
                        dc.b $0f ; 
                        dc.b $44 ; 
                        dc.b $0f ; 
                        dc.b $45 ; 
                        dc.b $0f ; 
                        dc.b $46 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $0e ; --> count
                        
A_9be0                  dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $66 ; 
                        dc.b $0f ; 
                        dc.b $67 ; 
                        dc.b $0f ; 
                        dc.b $68 ; 
                        dc.b $0f ; 
                        dc.b $69 ; 
                        dc.b $0f ; 
                        dc.b $6a ; 
                        dc.b $0f ; 
                        dc.b $6b ; 
                        dc.b $07 ; 
                        
A_9bf0                  dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $0b ; --> count
                        dc.b $47 ; 
                        dc.b $07 ; 
                        dc.b $48 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $03 ; --> count
                        dc.b $49 ; 
                        dc.b $07 ; 
                        dc.b $4a ; 
                        dc.b $07 ; 
                        
A_9c00                  dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $0e ; --> count
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $07 ; --> count
                        dc.b $6c ; 
                        dc.b $0f ; 
                        dc.b $6d ; 
                        dc.b $0f ; 
                        dc.b $6e ; 
                        dc.b $07 ; 
                        dc.b $6f ; 
                        dc.b $07 ; 
A_9c10                  dc.b $70 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $1c ; --> count
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $07 ; --> count
                        dc.b $71 ; 
                        dc.b $0f ; 
                        dc.b $72 ; 
                        dc.b $0f ; 
                        dc.b $73 ; 
                        dc.b $07 ; 
                        
A_9c20                  dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $16 ; --> count
                        dc.b $4b ; 
                        dc.b $07 ; 
                        dc.b $4c ; 
                        dc.b $07 ; 
                        dc.b $4d ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $05 ; --> count
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
A_9c30                  dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $08 ; --> count
                        dc.b $74 ; 
                        dc.b $0f ; 
                        dc.b $75 ; 
                        dc.b $0f ; 
                        dc.b $76 ; 
                        dc.b $07 ; 
                        dc.b $77 ; 
                        dc.b $07 ; 
                        dc.b $78 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $13 ; --> count
A_9c40                  dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $4f ; 
                        dc.b $0f ; 
                        dc.b $50 ; 
                        dc.b $0f ; 
                        dc.b $51 ; 
                        dc.b $07 ; 
                        dc.b $52 ; 
                        dc.b $07 ; 
                        dc.b $53 ; 
                        dc.b $07 ; 
                        dc.b $54 ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $0f ; 
                        
A_9c50                  dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $07 ; --> count
                        dc.b $79 ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $97 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $7a ; 
                        dc.b $07 ; 
                        dc.b $7b ; 
                        dc.b $07 ; 
                        dc.b $7c ; 
                        dc.b $07 ; 
A_9c60                  dc.b $7d ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $13 ; --> count
                        dc.b $55 ; 
                        dc.b $0f ; 
                        dc.b $56 ; 
                        dc.b $0f ; 
                        dc.b $57 ; 
                        dc.b $0f ; 
                        dc.b $58 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
A_9c70                  dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $59 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $06 ; --> count
                        dc.b $7e ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $97 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $7f ; 
                        dc.b $07 ; 
A_9c80                  dc.b $7c ; 
                        dc.b $0f ; 
                        dc.b $7d ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $16 ; --> count
                        dc.b $5a ; 
                        dc.b $07 ; 
                        dc.b $5b ; 
                        dc.b $07 ; 
                        dc.b $5c ; 
                        dc.b $07 ; 
                        dc.b $5d ; 
                        dc.b $07 ; 
A_9c90                  dc.b $5e ; 
                        dc.b $07 ; 
                        dc.b $5f ; 
                        dc.b $07 ; 
                        dc.b $98 ; 
                        dc.b $0f ; 
                        dc.b $82 ; 
                        dc.b $0f ; 
                        dc.b $83 ; 
                        dc.b $0f ; 
                        dc.b $84 ; 
                        dc.b $0f ; 
                        dc.b $85 ; 
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b $0f ; 
                        
A_9ca0                  dc.b $ff ; end of data
                        
                        dc.b $97 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $02 ; --> count
                        dc.b $87 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $1d ; --> count
                        dc.b $60 ; 
                        dc.b $07 ; 
                        dc.b $61 ; 
                        dc.b $0f ; 
                        dc.b $88 ; 
                        dc.b $0f ; 
A_9cb0                  dc.b $89 ; 
                        dc.b $0f ; 
                        dc.b $8a ; 
                        dc.b $0f ; 
                        dc.b $8b ; 
                        dc.b $0f ; 
                        dc.b $8c ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $97 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $03 ; --> count
                        dc.b $8e ; 
                        dc.b $07 ; 
                        dc.b $8f ; 
                        dc.b $07 ; 
A_9cc0                  dc.b $90 ; 
                        dc.b $07 ; 
                        dc.b $91 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $1b ; --> count
                        dc.b $62 ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $98 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $07 ; --> count
                        dc.b $8d ; 
                        dc.b $0f ; 
A_9cd0                  dc.b $80 ; 
                        dc.b $0f ; 
                        dc.b $81 ; 
                        dc.b $0f ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $97 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $04 ; --> count
                        dc.b $92 ; 
                        dc.b $07 ; 
                        dc.b $93 ; 
                        dc.b $07 ; 
                        dc.b $94 ; 
                        dc.b $07 ; 
                        dc.b $95 ; 
                        dc.b $0f ; 
A_9ce0                  dc.b $96 ; 
                        dc.b $07 ; 
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; --> T_9637 - screen $4800 with count
                        dc.b $0f ; --> T_9638 - color  $d800 with count
                        dc.b $15 ; --> count
                        
                        dc.b $ff ; end of data
                        
                        dc.b $ff ; end of map screen color data
; -------------------------------------------------------------------------------------------------------------- ;
; Map screen charset data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenCharBayMap        equ  *   ; 
A_9ce8                  dc.b $99 ; --> count
                        dc.b $00 ; --> BH_Scrn_GfxCharSets offset lo / $08
                        
MapChar00               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar01               dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar02               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        
MapChar03               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $c0 ; ##......
                        
MapChar04               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar05               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar06               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        
MapChar07               dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar08               dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar09               dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar0a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
MapChar0b               dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar0c               dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar0d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        
MapChar0e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        
MapChar0f               dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar10               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        
MapChar11               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
MapChar12               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar13               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar14               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar15               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar16               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
MapChar17               dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar18               dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
MapChar19               dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
MapChar1a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar1b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1c               dc.b $00 ; ........
                        dc.b $fc ; ######..
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1d               dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1e               dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar1f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f4 ; ####.#..
                        dc.b $f5 ; ####.#.#
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar20               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $57 ; .#.#.###
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        
MapChar21               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
MapChar22               dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar23               dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar24               dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar25               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
MapChar26               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        
MapChar27               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
MapChar28               dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar29               dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar2a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        
MapChar2b               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $30 ; ..##....
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        
MapChar2c               dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar2d               dc.b $ea ; ###.#.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar2e               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
MapChar2f               dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar30               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
MapChar31               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
MapChar32               dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar33               dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
MapChar34               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        
MapChar35               dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar36               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        
MapChar37               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
MapChar38               dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        
MapChar39               dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fe ; #######.
                        
MapChar3a               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
MapChar3b               dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar3c               dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        
MapChar3d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
MapChar3e               dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar3f               dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
MapChar40               dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $43 ; .#....##
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        
MapChar41               dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $e1 ; ###....#
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $1e ; ...####.
                        dc.b $00 ; ........
                        
MapChar42               dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
MapChar43               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0c ; ....##..
                        
MapChar44               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $bb ; #.###.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cc ; ##..##..
                        dc.b $00 ; ........
                        
MapChar45               dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        
MapChar46               dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
MapChar47               dc.b $fc ; ######..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar48               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        
MapChar49               dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $01 ; .......#
                        
MapChar4a               dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        
MapChar4b               dc.b $3e ; ..#####.
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar4c               dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        
MapChar4d               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        
MapChar4e               dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar4f               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $3e ; ..#####.
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
MapChar50               dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        
MapChar51               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
MapChar52               dc.b $00 ; ........
                        dc.b $78 ; .####...
                        dc.b $3c ; ..####..
                        dc.b $1e ; ...####.
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar53               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $78 ; .####...
                        dc.b $1e ; ...####.
                        dc.b $0f ; ....####
                        
MapChar54               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $38 ; ..###...
                        dc.b $0e ; ....###.
                        dc.b $07 ; .....###
                        
MapChar55               dc.b $fe ; #######.
                        dc.b $3a ; ..###.#.
                        dc.b $0e ; ....###.
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
MapChar56               dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        
MapChar57               dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $bc ; #.####..
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        
MapChar58               dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $e0 ; ###.....
                        dc.b $78 ; .####...
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
MapChar59               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $70 ; .###....
                        dc.b $7c ; .#####..
                        dc.b $ff ; ########
                        
MapChar5a               dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $e3 ; ###...##
                        dc.b $c1 ; ##.....#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar5b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
MapChar5c               dc.b $3c ; ..####..
                        dc.b $0e ; ....###.
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $3c ; ..####..
                        dc.b $0f ; ....####
                        
MapChar5d               dc.b $00 ; ........
                        dc.b $0c ; ....##..
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        
MapChar5e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $78 ; .####...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar5f               dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $83 ; #.....##
                        dc.b $e3 ; ###...##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar60               dc.b $3f ; ..######
                        dc.b $9f ; #..#####
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $0f ; ....####
                        
MapChar61               dc.b $ff ; ########
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $fa ; #####.#.
                        
MapChar62               dc.b $fe ; #######.
                        dc.b $3f ; ..######
                        dc.b $0e ; ....###.
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar63               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar64               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        
MapChar65               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $fc ; ######..
                        
MapChar66               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar67               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar68               dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fb ; #####.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar69               dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar6a               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
MapChar6b               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        
MapChar6c               dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar6d               dc.b $c0 ; ##......
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####

MapChar6e               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        
MapChar6f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        
MapChar70               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar71               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar72               dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        
MapChar73               dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $e0 ; ###.....
                        
MapChar74               dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $bf ; #.######
                        
MapChar75               dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        
MapChar76               dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar77               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
MapChar78               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        
MapChar79               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
MapChar7a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $f8 ; #####...
                        
MapChar7b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar7c               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar7d               dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
MapChar7e               dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        
MapChar7f               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        
MapChar80               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar81               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar82               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $bf ; #.######
                        
MapChar83               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        
MapChar84               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar85               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar86               dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar87               dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        
MapChar88               dc.b $af ; #.#.####
                        dc.b $b5 ; #.##.#.#
                        dc.b $b5 ; #.##.#.#
                        dc.b $b5 ; #.##.#.#
                        dc.b $b5 ; #.##.#.#
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar89               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar8a               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fb ; #####.##
                        dc.b $aa ; #.#.#.#.
                        
MapChar8b               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
MapChar8c               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ab ; #.#.#.##
                        
MapChar8d               dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
MapChar8e               dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar8f               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar90               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $ff ; ########
                        
MapChar91               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ff ; ########
                        
MapChar92               dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar93               dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar94               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar95               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
MapChar96               dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        
MapChar97               dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
MapChar98               dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
; -------------------------------------------------------------------------------------------------------------- ;
; Cave screen graphics data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataCave          equ  *   ; 
A_a1b2                  dc.b $09 ; unused
                        dc.b BLACK ; --> TabBackGroundColor
                        dc.b $02 ; --> BGCOL1
                        dc.b $0c ; --> BGCOL2
                        dc.b $4e ; --> screen $4800
                        dc.b $07 ; --> color  $d800
                        dc.b $01 ; --> screen $4800
                        dc.b $07 ; --> color  $d800
                        
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $03 ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
A_a1c0                  dc.b $03 ; 
                        dc.b $02 ; 
                        dc.b $04 ; 
                        dc.b $02 ; 
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $06 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $02 ; 
                        dc.b $07 ; 
                        dc.b $07 ; 
                        dc.b $08 ; 
                        dc.b $07 ; 
A_a1d0                  dc.b $09 ; 
                        dc.b $07 ; 
                        dc.b $0a ; 
                        dc.b $07 ; 
                        dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0c ; 
                        dc.b $07 ; 
                        dc.b $0d ; 
                        dc.b $07 ; 
                        dc.b $0e ; 
                        dc.b $07 ; 
                        dc.b $0f ; 
                        dc.b $07 ; 
                        dc.b $0c ; 
                        dc.b $07 ; 
A_a1e0                  dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0c ; 
                        dc.b $07 ; 
                        dc.b $0e ; 
                        dc.b $07 ; 
                        dc.b $10 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $03 ; 
                        dc.b $16 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
A_a1f0                  dc.b $17 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $18 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $04 ; 
                        dc.b $19 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $34 ; 
                        dc.b $07 ; 
A_a200                  dc.b $35 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $05 ; 
                        dc.b $11 ; 
                        dc.b $02 ; 
                        dc.b $12 ; 
                        dc.b $02 ; 
                        dc.b $13 ; 
                        dc.b $07 ; 
                        dc.b $14 ; 
                        dc.b $07 ; 
                        dc.b $15 ; 
                        dc.b $07 ; 
A_a210                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $0e ; 
                        dc.b $02 ; 
                        dc.b $07 ; 
                        dc.b $0a ; 
                        dc.b $07 ; 
                        dc.b $0c ; 
                        dc.b $07 ; 
                        dc.b $1a ; 
                        dc.b $07 ; 
                        dc.b $1b ; 
                        dc.b $07 ; 
                        dc.b $16 ; 
                        dc.b $07 ; 
A_a220                  dc.b $1c ; 
                        dc.b $07 ; 
                        dc.b $1d ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $06 ; 
                        dc.b $36 ; 
                        dc.b $07 ; 
                        dc.b $37 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $1c ; 
A_a230                  dc.b $1e ; 
                        dc.b $07 ; 
                        dc.b $03 ; 
                        dc.b $07 ; 
                        dc.b $1f ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $02 ; 
                        dc.b $17 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $19 ; 
                        dc.b $07 ; 
A_a240                  dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $03 ; 
                        dc.b $38 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $15 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $08 ; 
A_a250                  dc.b $1e ; 
                        dc.b $07 ; 
                        dc.b $21 ; 
                        dc.b $07 ; 
                        dc.b $22 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $02 ; 
                        dc.b $18 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $17 ; 
                        dc.b $07 ; 
A_a260                  dc.b $34 ; 
                        dc.b $07 ; 
                        dc.b $39 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $0d ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $11 ; 
A_a270                  dc.b $23 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $1c ; 
                        dc.b $07 ; 
                        dc.b $1d ; 
                        dc.b $07 ; 
                        dc.b $19 ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $36 ; 
                        dc.b $07 ; 
                        dc.b $3a ; 
                        dc.b $07 ; 
A_a280                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $06 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $1a ; 
                        dc.b $24 ; 
                        dc.b $07 ; 
                        dc.b $1f ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
A_a290                  dc.b $18 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $02 ; 
                        dc.b $3b ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $13 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
A_a2a0                  dc.b $07 ; 
                        dc.b $05 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $08 ; 
                        dc.b $1e ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $1d ; 
                        dc.b $07 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
A_a2b0                  dc.b $34 ; 
                        dc.b $07 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $23 ; 
                        dc.b $28 ; 
                        dc.b $07 ; 
                        dc.b $25 ; 
                        dc.b $0f ; 
                        dc.b $20 ; 
                        dc.b $0f ; 
                        dc.b $3d ; 
                        dc.b $07 ; 
A_a2c0                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $0e ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $10 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $04 ; 
A_a2d0                  dc.b $2a ; 
                        dc.b $07 ; 
                        dc.b $26 ; 
                        dc.b $0f ; 
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $3e ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $16 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
A_a2e0                  dc.b $07 ; 
                        dc.b $0d ; 
                        dc.b $2b ; 
                        dc.b $07 ; 
                        dc.b $1d ; 
                        dc.b $02 ; 
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $3f ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $06 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
A_a2f0                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $1d ; 
                        dc.b $2c ; 
                        dc.b $0f ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $40 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $24 ; 
A_a300                  dc.b $2d ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $41 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $0a ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
A_a310                  dc.b $07 ; 
                        dc.b $13 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $05 ; 
                        dc.b $2e ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $42 ; 
                        dc.b $07 ; 
A_a320                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $12 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $06 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $0a ; 
A_a330                  dc.b $2f ; 
                        dc.b $02 ; 
                        dc.b $19 ; 
                        dc.b $02 ; 
                        dc.b $4e ; 
                        dc.b $02 ; 
                        dc.b $43 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $24 ; 
                        dc.b $30 ; 
                        dc.b $02 ; 
                        dc.b $18 ; 
                        dc.b $02 ; 
A_a340                  dc.b $19 ; 
                        dc.b $02 ; 
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $44 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $23 ; 
                        dc.b $31 ; 
                        dc.b $02 ; 
                        dc.b $32 ; 
                        dc.b $02 ; 
                        dc.b $18 ; 
                        dc.b $02 ; 
A_a350                  dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $45 ; 
                        dc.b $07 ; 
                        dc.b $46 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $09 ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $1a ; 
A_a360                  dc.b $33 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $03 ; 
                        dc.b $48 ; 
                        dc.b $07 ; 
                        dc.b $49 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $0f ; 
                        dc.b $47 ; 
                        dc.b $03 ; 
A_a370                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $13 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $05 ; 
                        dc.b $4a ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $1a ; 
                        dc.b $52 ; 
                        dc.b $07 ; 
A_a380                  dc.b $53 ; 
                        dc.b $07 ; 
                        dc.b $54 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $05 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $05 ; 
                        dc.b $4b ; 
                        dc.b $07 ; 
                        dc.b $4c ; 
                        dc.b $07 ; 
A_a390                  dc.b $4d ; 
                        dc.b $07 ; 
                        dc.b $4f ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $15 ; 
                        dc.b $50 ; 
                        dc.b $07 ; 
                        dc.b $51 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4e ; 
                        dc.b $07 ; 
                        dc.b $02 ; 
A_a3a0                  dc.b $55 ; 
                        dc.b $07 ; 
                        dc.b $56 ; 
                        dc.b $07 ; 
                        dc.b $57 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $ff ; end of screen
; -------------------------------------------------------------------------------------------------------------- ;
; Cave screen charset data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenCharCave          equ  *   ; 
                        dc.b $58 ; --> count
                        dc.b $00 ; --> BH_Scrn_GfxCharSets offset lo / $08
                        
CaveChar00              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar01              dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $80 ; #.......
                        dc.b $30 ; ..##....
                        
CaveChar02              dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar03              dc.b $f7 ; ####.###
                        dc.b $f7 ; ####.###
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $47 ; .#...###
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        
CaveChar04              dc.b $fb ; #####.##
                        dc.b $fb ; #####.##
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $c7 ; ##...###
                        
CaveChar05              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar06              dc.b $ff ; ########
                        dc.b $fb ; #####.##
                        dc.b $fb ; #####.##
                        dc.b $f7 ; ####.###
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        
CaveChar07              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c3 ; ##....##
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $80 ; #.......
                        
CaveChar08              dc.b $df ; ##.#####
                        dc.b $df ; ##.#####
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
CaveChar09              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f1 ; ####...#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar0a              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar0b              dc.b $ef ; ###.####
                        dc.b $ef ; ###.####
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $c3 ; ##....##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar0c              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $00 ; ........
                        
CaveChar0d              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c3 ; ##....##
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $00 ; ........
                        
CaveChar0e              dc.b $ef ; ###.####
                        dc.b $ef ; ###.####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $c7 ; ##...###
                        dc.b $c7 ; ##...###
                        dc.b $c3 ; ##....##
                        dc.b $00 ; ........
                        
CaveChar0f              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
CaveChar10              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c7 ; ##...###
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $81 ; #......#
                        dc.b $01 ; .......#
                        
CaveChar11              dc.b $c3 ; ##....##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar12              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar13              dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $f1 ; ####...#
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar14              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar15              dc.b $ff ; ########
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar16              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f7 ; ####.###
                        dc.b $f7 ; ####.###
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        
CaveChar17              dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fd ; ######.#
                        dc.b $f9 ; #####..#
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $ef ; ###.####
                        
CaveChar18              dc.b $f7 ; ####.###
                        dc.b $f7 ; ####.###
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $c7 ; ##...###
                        dc.b $c3 ; ##....##
                        dc.b $87 ; #....###
                        
CaveChar19              dc.b $ff ; ########
                        dc.b $fd ; ######.#
                        dc.b $f9 ; #####..#
                        dc.b $f9 ; #####..#
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        dc.b $e6 ; ###..##.
                        
CaveChar1a              dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $e1 ; ###....#
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $81 ; #......#
                        dc.b $01 ; .......#
                        
CaveChar1b              dc.b $fb ; #####.##
                        dc.b $fb ; #####.##
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $c7 ; ##...###
                        
CaveChar1c              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        
CaveChar1d              dc.b $87 ; #....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
CaveChar1e              dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar1f              dc.b $f8 ; #####...
                        dc.b $f1 ; ####...#
                        dc.b $f1 ; ####...#
                        dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $c3 ; ##....##
                        dc.b $87 ; #....###
                        dc.b $87 ; #....###
                        
CaveChar20              dc.b $fc ; ######..
                        dc.b $f1 ; ####...#
                        dc.b $c5 ; ##...#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
CaveChar21              dc.b $ff ; ########
                        dc.b $c7 ; ##...###
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $c3 ; ##....##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
CaveChar22              dc.b $ef ; ###.####
                        dc.b $ef ; ###.####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $9f ; #..#####
                        dc.b $9f ; #..#####
                        dc.b $9f ; #..#####
                        
CaveChar23              dc.b $3e ; ..#####.
                        dc.b $3e ; ..#####.
                        dc.b $1c ; ...###..
                        dc.b $1c ; ...###..
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
CaveChar24              dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
CaveChar25              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f1 ; ####...#
                        
CaveChar26              dc.b $f1 ; ####...#
                        dc.b $c5 ; ##...#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        
CaveChar27              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar28              dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $63 ; .##...##
                        dc.b $63 ; .##...##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
CaveChar29              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $8f ; #...####
                        dc.b $8f ; #...####
                        dc.b $9f ; #..#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
CaveChar2a              dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar2b              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar2c              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        
CaveChar2d              dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        
CaveChar2e              dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
CaveChar2f              dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar30              dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar31              dc.b $fe ; #######.
                        dc.b $3c ; ..####..
                        dc.b $0e ; ....###.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar32              dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
CaveChar33              dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar34              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $df ; ##.#####
                        dc.b $df ; ##.#####
                        dc.b $ef ; ###.####
                        dc.b $ef ; ###.####
                        dc.b $f7 ; ####.###
                        
CaveChar35              dc.b $b0 ; #.##....
                        dc.b $70 ; .###....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $ec ; ###.##..
                        dc.b $cc ; ##..##..
                        dc.b $5c ; .#.###..
                        dc.b $ec ; ###.##..
                        
CaveChar36              dc.b $f7 ; ####.###
                        dc.b $f7 ; ####.###
                        dc.b $fb ; #####.##
                        dc.b $fb ; #####.##
                        dc.b $fb ; #####.##
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        
CaveChar37              dc.b $ec ; ###.##..
                        dc.b $dc ; ##.###..
                        dc.b $be ; #.#####.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fb ; #####.##
                        dc.b $f7 ; ####.###
                        dc.b $fe ; #######.
                        
CaveChar38              dc.b $7c ; .#####..
                        dc.b $7c ; .#####..
                        dc.b $3e ; ..#####.
                        dc.b $3e ; ..#####.
                        dc.b $3e ; ..#####.
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        
CaveChar39              dc.b $1e ; ...####.
                        dc.b $0c ; ....##..
                        dc.b $08 ; ....#...
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        
CaveChar3a              dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        
CaveChar3b              dc.b $30 ; ..##....
                        dc.b $9c ; #..###..
                        dc.b $9c ; #..###..
                        dc.b $ce ; ##..###.
                        dc.b $ce ; ##..###.
                        dc.b $e6 ; ###..##.
                        dc.b $e4 ; ###..#..
                        dc.b $c0 ; ##......
                        
CaveChar3c              dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        
CaveChar3d              dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e6 ; ###..##.
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $ec ; ###.##..
                        dc.b $cc ; ##..##..
                        
CaveChar3e              dc.b $cc ; ##..##..
                        dc.b $e6 ; ###..##.
                        dc.b $e4 ; ###..#..
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
CaveChar3f              dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $70 ; .###....
                        dc.b $30 ; ..##....
                        dc.b $a0 ; #.#.....
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        
CaveChar40              dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
CaveChar41              dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        
CaveChar42              dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $9c ; #..###..
                        dc.b $ce ; ##..###.
                        dc.b $e6 ; ###..##.
                        dc.b $e6 ; ###..##.
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        
CaveChar43              dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar44              dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $8c ; #...##..
                        
CaveChar45              dc.b $7c ; .#####..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar46              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c2 ; ##....#.
                        dc.b $8f ; #...####
                        
CaveChar47              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
CaveChar48              dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $e1 ; ###....#
                        dc.b $cf ; ##..####
                        dc.b $bf ; #.######
                        
CaveChar49              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
CaveChar4a              dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
CaveChar4b              dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $ef ; ###.####
                        dc.b $df ; ##.#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar4c              dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar4d              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        dc.b $e7 ; ###..###
                        dc.b $df ; ##.#####
                        
CaveChar4e              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar4f              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        
CaveChar50              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
CaveChar51              dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $e7 ; ###..###
                        dc.b $f3 ; ####..##
                        dc.b $fd ; ######.#
                        dc.b $ff ; ########
                        
CaveChar52              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        
CaveChar53              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar54              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
CaveChar55              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f3 ; ####..##
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar56              dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
CaveChar57              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
; -------------------------------------------------------------------------------------------------------------- ;
; Sea shootouts color screen data .hbu.
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataOpenSea       equ  *   ; 
A_a66e                  dc.b $09 ; 
                        dc.b $03 ; 
A_a670                  dc.b $06 ; 
                        dc.b $07 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $28 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
A_a680                  dc.b $30 ; 
                        dc.b $20 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $20 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $73 ; 
                        dc.b $30 ; 
A_a690                  dc.b $2a ; 
                        dc.b $01 ; 
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $1d ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
A_a6a0                  dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $28 ; 
                        dc.b $01 ; 
                        dc.b $29 ; 
                        dc.b $01 ; 
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $02 ; 
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
A_a6b0                  dc.b $30 ; 
                        dc.b $10 ; 
                        dc.b $73 ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $02 ; 
                        dc.b $3f ; 
                        dc.b $01 ; 
                        dc.b $40 ; 
                        dc.b $01 ; 
                        dc.b $41 ; 
                        dc.b $01 ; 
                        dc.b $42 ; 
                        dc.b $01 ; 
A_a6c0                  dc.b $43 ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $05 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $2c ; 
                        dc.b $01 ; 
                        dc.b $2d ; 
                        dc.b $01 ; 
                        dc.b $2e ; 
                        dc.b $01 ; 
A_a6d0                  dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $11 ; 
                        dc.b $45 ; 
                        dc.b $01 ; 
                        dc.b $46 ; 
                        dc.b $01 ; 
                        dc.b $47 ; 
                        dc.b $01 ; 
A_a6e0                  dc.b $48 ; 
                        dc.b $01 ; 
                        dc.b $49 ; 
                        dc.b $01 ; 
                        dc.b $4a ; 
                        dc.b $01 ; 
                        dc.b $4b ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
A_a6f0                  dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $4d ; 
                        dc.b $01 ; 
                        dc.b $4e ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $4f ; 
                        dc.b $01 ; 
                        dc.b $02 ; 
A_a700                  dc.b $50 ; 
                        dc.b $01 ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $52 ; 
                        dc.b $01 ; 
                        dc.b $44 ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0c ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $02 ; 
A_a710                  dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0c ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $06 ; 
                        dc.b $53 ; 
                        dc.b $01 ; 
                        dc.b $54 ; 
                        dc.b $01 ; 
                        dc.b $55 ; 
                        dc.b $01 ; 
                        dc.b $56 ; 
                        dc.b $01 ; 
A_a720                  dc.b $57 ; 
                        dc.b $01 ; 
                        dc.b $58 ; 
                        dc.b $01 ; 
                        dc.b $59 ; 
                        dc.b $01 ; 
                        dc.b $5a ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $02 ; 
A_a730                  dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $60 ; 
                        dc.b $01 ; 
                        dc.b $61 ; 
                        dc.b $01 ; 
                        dc.b $62 ; 
                        dc.b $01 ; 
                        dc.b $63 ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $04 ; 
A_a740                  dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $22 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0f ; 
A_a750                  dc.b $68 ; 
                        dc.b $01 ; 
                        dc.b $69 ; 
                        dc.b $01 ; 
                        dc.b $6a ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $10 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $30 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
A_a760                  dc.b $03 ; 
                        dc.b $08 ; 
                        dc.b $64 ; 
                        dc.b $01 ; 
                        dc.b $65 ; 
                        dc.b $01 ; 
                        dc.b $66 ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $06 ; 
                        dc.b $2f ; 
                        dc.b $00 ; 
                        dc.b $73 ; 
                        dc.b $00 ; 
A_a770                  dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $6c ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $04 ; 
                        dc.b $32 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $15 ; 
A_a780                  dc.b $31 ; 
                        dc.b $00 ; 
                        dc.b $4c ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $02 ; 
                        dc.b $6d ; 
                        dc.b $01 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $02 ; 
                        dc.b $6f ; 
                        dc.b $00 ; 
A_a790                  dc.b $6b ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $3b ; 
                        dc.b $00 ; 
                        dc.b $33 ; 
                        dc.b $00 ; 
                        dc.b $34 ; 
                        dc.b $00 ; 
                        dc.b $35 ; 
                        dc.b $00 ; 
                        dc.b $36 ; 
                        dc.b $00 ; 
A_a7a0                  dc.b $37 ; 
                        dc.b $00 ; 
                        dc.b $38 ; 
                        dc.b $00 ; 
                        dc.b $39 ; 
                        dc.b $00 ; 
                        dc.b $3a ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $03 ; 
                        dc.b $2b ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $73 ; 
A_a7b0                  dc.b $03 ; 
                        dc.b $05 ; 
                        dc.b $73 ; 
                        dc.b $00 ; 
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $6c ; 
                        dc.b $01 ; 
                        dc.b $73 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $30 ; 
                        dc.b $0e ; 
                        dc.b $0a ; 
                        dc.b $72 ; 
                        dc.b $09 ; 
A_a7c0                  dc.b $71 ; 
                        dc.b $08 ; 
                        dc.b $70 ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $30 ; 
                        dc.b $0e ; 
                        dc.b $05 ; 
                        dc.b $3c ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $3d ; 
                        dc.b $08 ; 
                        dc.b $07 ; 
                        dc.b $3e ; 
                        dc.b $08 ; 
A_a7d0                  dc.b $6e ; 
                        dc.b $09 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $30 ; 
                        dc.b $0e ; 
                        dc.b $07 ; 
                        dc.b $5b ; 
                        dc.b $08 ; 
                        dc.b $5c ; 
                        dc.b $08 ; 
                        dc.b $5d ; 
                        dc.b $08 ; 
                        dc.b $5e ; 
                        dc.b $08 ; 
                        dc.b $5f ; 
                        dc.b $09 ; 
A_a7e0                  dc.b $ff ; end of data
                        
                        dc.b $30 ; 
                        dc.b $0e ; 
                        dc.b $f0 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $ff ; end of screen
; -------------------------------------------------------------------------------------------------------------- ;
; Sea shootouts hires screen data .hbu.
; -------------------------------------------------------------------------------------------------------------- ;
ScreenCharOpenSea       equ  *   ; 
                        dc.b $4c ; 
                        dc.b $28 ; 
                        
OpenSeaChar00           dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar01           dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $e3 ; ###...##
                        dc.b $c7 ; ##...###
                        dc.b $ff ; ########
                        
OpenSeaChar02           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $38 ; ..###...
                        dc.b $3c ; ..####..
                        dc.b $1e ; ...####.
                        dc.b $7e ; .######.
                        dc.b $ff ; ########
                        
OpenSeaChar03           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $10 ; ...#....
                        dc.b $38 ; ..###...
                        dc.b $7c ; .#####..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        
OpenSeaChar04           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c7 ; ##...###
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        
OpenSeaChar05           dc.b $87 ; #....###
                        dc.b $fe ; #######.
                        dc.b $1c ; ...###..
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
OpenSeaChar06           dc.b $f8 ; #####...
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
OpenSeaChar07           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        
OpenSeaChar08           dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar09           dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        
OpenSeaChar0a           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $20 ; ..#.....
                        dc.b $70 ; .###....
                        dc.b $22 ; ..#...#.
                        
OpenSeaChar0b           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $44 ; .#...#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar0c           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $44 ; .#...#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar0d           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar0e           dc.b $73 ; .###..##
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar0f           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar10           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $08 ; ....#...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar11           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $88 ; #...#...
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar12           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        
OpenSeaChar13           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $04 ; .....#..
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
OpenSeaChar14           dc.b $57 ; .#.#.###
                        dc.b $57 ; .#.#.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar15           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar16           dc.b $f5 ; ####.#.#
                        dc.b $e9 ; ###.#..#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar17           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        
OpenSeaChar18           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3e ; ..#####.
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        
OpenSeaChar19           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $7e ; .######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar1a           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        
OpenSeaChar1b           dc.b $0e ; ....###.
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7e ; .######.
                        dc.b $7c ; .#####..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar1c           dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar1d           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        
OpenSeaChar1e           dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
OpenSeaChar1f           dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $cf ; ##..####
                        
OpenSeaChar20           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c3 ; ##....##
                        dc.b $ff ; ########
                        dc.b $cc ; ##..##..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar21           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar22           dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $e3 ; ###...##
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar23           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        
OpenSeaChar24           dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
OpenSeaChar25           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
OpenSeaChar26           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f1 ; ####...#
                        dc.b $cf ; ##..####
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $ff ; ########
                        
OpenSeaChar27           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar28           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        
OpenSeaChar29           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
OpenSeaChar2a           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar2b           dc.b $33 ; ..##..##
                        dc.b $ff ; ########
                        dc.b $30 ; ..##....
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar2c           dc.b $c3 ; ##....##
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $df ; ##.#####
                        dc.b $ef ; ###.####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar2d           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar2e           dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
OpenSeaChar2f           dc.b $c7 ; ##...###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
OpenSeaChar30           dc.b $f8 ; #####...
                        dc.b $f3 ; ####..##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
OpenSeaChar31           dc.b $80 ; #.......
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $fe ; #######.
                        dc.b $c3 ; ##....##
                        dc.b $f1 ; ####...#
                        
OpenSeaChar32           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        
OpenSeaChar33           dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        dc.b $4f ; .#..####
                        dc.b $53 ; .#.#..##
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar34           dc.b $4d ; .#..##.#
                        dc.b $4d ; .#..##.#
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar35           dc.b $55 ; .#.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar36           dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $01 ; .......#
                        dc.b $fd ; ######.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar37           dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $f7 ; ####.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar38           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0c ; ....##..
                        dc.b $3f ; ..######
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        
OpenSeaChar39           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3e ; ..#####.
                        dc.b $f1 ; ####...#
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $e0 ; ###.....
                        
OpenSeaChar3a           dc.b $3c ; ..####..
                        dc.b $7e ; .######.
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $07 ; .....###
                        dc.b $ff ; ########
                        dc.b $f8 ; #####...
                        dc.b $1f ; ...#####
                        
OpenSeaChar3b           dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        
OpenSeaChar3c           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $23 ; ..#...##
                        dc.b $f8 ; #####...
                        dc.b $7f ; .#######
                        
OpenSeaChar3d           dc.b $0e ; ....###.
                        dc.b $1f ; ...#####
                        dc.b $03 ; ......##
                        dc.b $f8 ; #####...
                        dc.b $f7 ; ####.###
                        dc.b $fe ; #######.
                        dc.b $f0 ; ####....
                        dc.b $00 ; ........
                        
OpenSeaChar3e           dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $d8 ; ##.##...
                        dc.b $b4 ; #.##.#..
                        dc.b $fc ; ######..
                        dc.b $d6 ; ##.#.##.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        
OpenSeaChar3f           dc.b $f0 ; ####....
                        dc.b $78 ; .####...
                        dc.b $3e ; ..#####.
                        dc.b $1f ; ...#####
                        dc.b $0e ; ....###.
                        dc.b $04 ; .....#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar40           dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar41           dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar42           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        
OpenSeaChar43           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $60 ; .##.....
                        dc.b $f0 ; ####....
                        dc.b $ff ; ########
                        
OpenSeaChar44           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $38 ; ..###...
                        dc.b $fe ; #######.
                        dc.b $00 ; ........
                        
OpenSeaChar45           dc.b $00 ; ........
                        dc.b $7c ; .#####..
                        dc.b $1e ; ...####.
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
OpenSeaChar46           dc.b $55 ; .#.#.#.#
                        dc.b $f7 ; ####.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar47           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        
OpenSeaChar48           dc.b $fd ; ######.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar49           dc.b $ff ; ########
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar4a           dc.b $df ; ##.#####
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
OpenSeaChar4b           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
; Hill screen graphics data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataHill          equ  *   ; 
A_aa48                  dc.b $09 ; 
                        dc.b $00 ; 
                        dc.b $09 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $03 ; 
                        dc.b $8b ; 
A_aa50                  dc.b $78 ; 
                        dc.b $0b ; 
                        dc.b $79 ; 
                        dc.b $0a ; 
                        dc.b $7a ; 
                        dc.b $0b ; 
                        dc.b $7b ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $03 ; 
                        dc.b $23 ; 
                        dc.b $7d ; 
                        dc.b $0b ; 
                        dc.b $7e ; 
                        dc.b $0e ; 
A_aa60                  dc.b $d7 ; 
                        dc.b $0e ; 
                        dc.b $d8 ; 
                        dc.b $0e ; 
                        dc.b $7f ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $03 ; 
                        dc.b $22 ; 
                        dc.b $80 ; 
                        dc.b $0a ; 
                        dc.b $81 ; 
                        dc.b $0a ; 
                        dc.b $82 ; 
                        dc.b $02 ; 
A_aa70                  dc.b $83 ; 
                        dc.b $02 ; 
                        dc.b $84 ; 
                        dc.b $02 ; 
                        dc.b $85 ; 
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b $0a ; 
                        dc.b $87 ; 
                        dc.b $0a ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $03 ; 
                        dc.b $1f ; 
                        dc.b $88 ; 
                        dc.b $0a ; 
A_aa80                  dc.b $89 ; 
                        dc.b $02 ; 
                        dc.b $5b ; 
                        dc.b $02 ; 
                        dc.b $8a ; 
                        dc.b $02 ; 
                        dc.b $8b ; 
                        dc.b $02 ; 
                        dc.b $8c ; 
                        dc.b $02 ; 
                        dc.b $8d ; 
                        dc.b $02 ; 
                        dc.b $8e ; 
                        dc.b $02 ; 
                        dc.b $5c ; 
                        dc.b $02 ; 
A_aa90                  dc.b $8f ; 
                        dc.b $0a ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $03 ; 
                        dc.b $0e ; 
                        dc.b $5d ; 
                        dc.b $0d ; 
                        dc.b $5e ; 
                        dc.b $0d ; 
                        dc.b $5f ; 
                        dc.b $0d ; 
                        dc.b $60 ; 
                        dc.b $0d ; 
                        dc.b $61 ; 
                        dc.b $0d ; 
A_aaa0                  dc.b $62 ; 
                        dc.b $0d ; 
                        dc.b $63 ; 
                        dc.b $0d ; 
                        dc.b $64 ; 
                        dc.b $0d ; 
                        dc.b $65 ; 
                        dc.b $0d ; 
                        dc.b $5d ; 
                        dc.b $0d ; 
                        dc.b $5e ; 
                        dc.b $0d ; 
                        dc.b $5f ; 
                        dc.b $0d ; 
                        dc.b $60 ; 
                        dc.b $0d ; 
A_aab0                  dc.b $90 ; 
                        dc.b $0d ; 
                        dc.b $91 ; 
                        dc.b $0d ; 
                        dc.b $92 ; 
                        dc.b $0d ; 
                        dc.b $93 ; 
                        dc.b $02 ; 
                        dc.b $94 ; 
                        dc.b $02 ; 
                        dc.b $95 ; 
                        dc.b $02 ; 
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $96 ; 
                        dc.b $02 ; 
A_aac0                  dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $03 ; 
                        dc.b $97 ; 
                        dc.b $02 ; 
                        dc.b $98 ; 
                        dc.b $0a ; 
                        dc.b $99 ; 
                        dc.b $0d ; 
                        dc.b $62 ; 
                        dc.b $0d ; 
                        dc.b $63 ; 
                        dc.b $0d ; 
                        dc.b $64 ; 
                        dc.b $0d ; 
A_aad0                  dc.b $65 ; 
                        dc.b $0d ; 
                        dc.b $5d ; 
                        dc.b $0d ; 
                        dc.b $5e ; 
                        dc.b $0d ; 
                        dc.b $5f ; 
                        dc.b $0d ; 
                        dc.b $60 ; 
                        dc.b $0d ; 
                        dc.b $61 ; 
                        dc.b $0d ; 
                        dc.b $62 ; 
                        dc.b $0d ; 
                        dc.b $63 ; 
                        dc.b $0d ; 
A_aae0                  dc.b $64 ; 
                        dc.b $0d ; 
                        dc.b $65 ; 
                        dc.b $0d ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5b ; 
                        dc.b $05 ; 
                        dc.b $0c ; 
                        dc.b $9a ; 
                        dc.b $0d ; 
                        dc.b $9b ; 
                        dc.b $0d ; 
                        dc.b $9c ; 
                        dc.b $02 ; 
                        dc.b $9d ; 
                        dc.b $02 ; 
A_aaf0                  dc.b $5b ; 
                        dc.b $02 ; 
                        dc.b $9e ; 
                        dc.b $02 ; 
                        dc.b $9f ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $a0 ; 
                        dc.b $02 ; 
                        dc.b $a1 ; 
                        dc.b $02 ; 
                        dc.b $5c ; 
                        dc.b $02 ; 
A_ab00                  dc.b $a2 ; 
                        dc.b $02 ; 
                        dc.b $a3 ; 
                        dc.b $0a ; 
                        dc.b $a4 ; 
                        dc.b $0d ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5b ; 
                        dc.b $05 ; 
                        dc.b $0d ; 
                        dc.b $66 ; 
                        dc.b $0d ; 
                        dc.b $67 ; 
                        dc.b $0d ; 
                        dc.b $68 ; 
                        dc.b $0d ; 
A_ab10                  dc.b $69 ; 
                        dc.b $0d ; 
                        dc.b $6a ; 
                        dc.b $0d ; 
                        dc.b $6b ; 
                        dc.b $0d ; 
                        dc.b $6c ; 
                        dc.b $0d ; 
                        dc.b $6d ; 
                        dc.b $0d ; 
                        dc.b $6e ; 
                        dc.b $0d ; 
                        dc.b $66 ; 
                        dc.b $0d ; 
                        dc.b $67 ; 
                        dc.b $0d ; 
A_ab20                  dc.b $a5 ; 
                        dc.b $0d ; 
                        dc.b $a6 ; 
                        dc.b $0d ; 
                        dc.b $a7 ; 
                        dc.b $02 ; 
                        dc.b $a8 ; 
                        dc.b $02 ; 
                        dc.b $a9 ; 
                        dc.b $02 ; 
                        dc.b $aa ; 
                        dc.b $02 ; 
                        dc.b $ab ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
A_ab30                  dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $ac ; 
                        dc.b $02 ; 
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $ad ; 
                        dc.b $02 ; 
                        dc.b $ae ; 
                        dc.b $02 ; 
                        dc.b $af ; 
                        dc.b $02 ; 
                        dc.b $b0 ; 
                        dc.b $0a ; 
                        dc.b $b1 ; 
                        dc.b $0d ; 
A_ab40                  dc.b $6b ; 
                        dc.b $0d ; 
                        dc.b $6c ; 
                        dc.b $0d ; 
                        dc.b $6d ; 
                        dc.b $0d ; 
                        dc.b $6e ; 
                        dc.b $0d ; 
                        dc.b $66 ; 
                        dc.b $0d ; 
                        dc.b $67 ; 
                        dc.b $0d ; 
                        dc.b $68 ; 
                        dc.b $0d ; 
                        dc.b $69 ; 
                        dc.b $0d ; 
A_ab50                  dc.b $6a ; 
                        dc.b $0d ; 
                        dc.b $6b ; 
                        dc.b $0d ; 
                        dc.b $6c ; 
                        dc.b $0d ; 
                        dc.b $6d ; 
                        dc.b $0d ; 
                        dc.b $6e ; 
                        dc.b $0d ; 
                        dc.b $6f ; 
                        dc.b $0f ; 
                        dc.b $70 ; 
                        dc.b $0f ; 
                        dc.b $71 ; 
                        dc.b $0f ; 
A_ab60                  dc.b $72 ; 
                        dc.b $0f ; 
                        dc.b $73 ; 
                        dc.b $0f ; 
                        dc.b $74 ; 
                        dc.b $0f ; 
                        dc.b $75 ; 
                        dc.b $0f ; 
                        dc.b $76 ; 
                        dc.b $0f ; 
                        dc.b $77 ; 
                        dc.b $0f ; 
                        dc.b $6f ; 
                        dc.b $0f ; 
                        dc.b $ba ; 
                        dc.b $0f ; 
A_ab70                  dc.b $b2 ; 
                        dc.b $0f ; 
                        dc.b $b3 ; 
                        dc.b $02 ; 
                        dc.b $5b ; 
                        dc.b $02 ; 
                        dc.b $b4 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5b ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $b5 ; 
                        dc.b $02 ; 
                        dc.b $a7 ; 
                        dc.b $02 ; 
A_ab80                  dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $04 ; 
                        dc.b $b6 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $b7 ; 
                        dc.b $02 ; 
                        dc.b $b8 ; 
                        dc.b $0f ; 
                        dc.b $b9 ; 
                        dc.b $0f ; 
A_ab90                  dc.b $76 ; 
                        dc.b $0f ; 
                        dc.b $77 ; 
                        dc.b $0f ; 
                        dc.b $6f ; 
                        dc.b $0f ; 
                        dc.b $70 ; 
                        dc.b $0f ; 
                        dc.b $71 ; 
                        dc.b $0f ; 
                        dc.b $72 ; 
                        dc.b $0f ; 
                        dc.b $73 ; 
                        dc.b $0f ; 
                        dc.b $74 ; 
                        dc.b $0f ; 
A_aba0                  dc.b $75 ; 
                        dc.b $0f ; 
                        dc.b $76 ; 
                        dc.b $0f ; 
                        dc.b $77 ; 
                        dc.b $0f ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $07 ; 
                        dc.b $0a ; 
                        dc.b $bc ; 
                        dc.b $0f ; 
                        dc.b $bd ; 
                        dc.b $02 ; 
                        dc.b $be ; 
                        dc.b $02 ; 
A_abb0                  dc.b $bf ; 
                        dc.b $02 ; 
                        dc.b $8a ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $03 ; 
                        dc.b $c0 ; 
                        dc.b $02 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $c1 ; 
                        dc.b $02 ; 
A_abc0                  dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $c2 ; 
                        dc.b $02 ; 
                        dc.b $c3 ; 
                        dc.b $02 ; 
                        dc.b $a7 ; 
                        dc.b $02 ; 
                        dc.b $5c ; 
                        dc.b $02 ; 
                        dc.b $c4 ; 
                        dc.b $0a ; 
                        dc.b $c5 ; 
                        dc.b $0f ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
A_abd0                  dc.b $07 ; 
                        dc.b $17 ; 
                        dc.b $c6 ; 
                        dc.b $07 ; 
                        dc.b $c7 ; 
                        dc.b $0f ; 
                        dc.b $c8 ; 
                        dc.b $0f ; 
                        dc.b $c9 ; 
                        dc.b $0f ; 
                        dc.b $ca ; 
                        dc.b $0f ; 
                        dc.b $cb ; 
                        dc.b $0f ; 
                        dc.b $cc ; 
                        dc.b $0f ; 
A_abe0                  dc.b $cd ; 
                        dc.b $0f ; 
                        dc.b $ce ; 
                        dc.b $0f ; 
                        dc.b $cf ; 
                        dc.b $0f ; 
                        dc.b $d0 ; 
                        dc.b $0f ; 
                        dc.b $d1 ; 
                        dc.b $0f ; 
                        dc.b $d2 ; 
                        dc.b $0f ; 
                        dc.b $d3 ; 
                        dc.b $0f ; 
                        dc.b $d4 ; 
                        dc.b $0f ; 
A_abf0                  dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $07 ; 
                        dc.b $fe ; 
                        dc.b $ff ; end of data
                        
                        dc.b $5c ; 
                        dc.b $07 ; 
                        dc.b $27 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $ff ; end of screen
; -------------------------------------------------------------------------------------------------------------- ;
; Hill screen charset data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenCharHill          equ  *   ; 
                        dc.b $7e ; --> count
                        dc.b $5b ; --> BH_Scrn_GfxCharSets offset lo / $08
                        
HillChar00              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar01              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar02              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        
HillChar03              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar04              dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar05              dc.b $ea ; ###.#.#.
                        dc.b $fb ; #####.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar06              dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $fb ; #####.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar07              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        
HillChar08              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
HillChar09              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fe ; #######.
                        
HillChar0a              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
HillChar0b              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $c4 ; ##...#..
                        
HillChar0c              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $c3 ; ##....##
                        dc.b $44 ; .#...#..
                        
HillChar0d              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $44 ; .#...#..
                        
HillChar0e              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        
HillChar0f              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $4f ; .#..####
                        dc.b $43 ; .#....##
                        
HillChar10              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $c4 ; ##...#..
                        
HillChar11              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $c4 ; ##...#..
                        dc.b $44 ; .#...#..
                        
HillChar12              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $77 ; .###.###
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        
HillChar13              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $4f ; .#..####
                        dc.b $47 ; .#...###
                        
HillChar14              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $cf ; ##..####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar15              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $c4 ; ##...#..
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar16              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $cc ; ##..##..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar17              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $40 ; .#......
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar18              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $4f ; .#..####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar19              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $c4 ; ##...#..
                        dc.b $f7 ; ####.###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar1a              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $47 ; .#...###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar1b              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar1c              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $f4 ; ####.#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar1d              dc.b $ff ; ########
                        dc.b $f0 ; ####....
                        dc.b $c5 ; ##...#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $50 ; .#.#....
                        
HillChar1e              dc.b $00 ; ........
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $40 ; .#......
                        dc.b $15 ; ...#.#.#
                        
HillChar1f              dc.b $3f ; ..######
                        dc.b $43 ; .#....##
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $01 ; .......#
                        
HillChar20              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
HillChar21              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
HillChar22              dc.b $fc ; ######..
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $d0 ; ##.#....
                        
HillChar23              dc.b $05 ; .....#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $50 ; .#.#....
                        dc.b $00 ; ........
                        
HillChar24              dc.b $3f ; ..######
                        dc.b $5f ; .#.#####
                        dc.b $57 ; .#.#.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $01 ; .......#
                        
HillChar25              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $8f ; #...####
                        dc.b $3c ; ..####..
                        dc.b $7d ; .#####.#
                        dc.b $7d ; .#####.#
                        
HillChar26              dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $87 ; #....###
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar27              dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $cf ; ##..####
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $eb ; ###.#.##
                        dc.b $ff ; ########
                        
HillChar28              dc.b $07 ; .....###
                        dc.b $8f ; #...####
                        dc.b $cf ; ##..####
                        dc.b $e7 ; ###..###
                        dc.b $f7 ; ####.###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar29              dc.b $c0 ; ##......
                        dc.b $e1 ; ###....#
                        dc.b $f1 ; ####...#
                        dc.b $f9 ; #####..#
                        dc.b $fd ; ######.#
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
HillChar2a              dc.b $02 ; ......#.
                        dc.b $c2 ; ##....#.
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $c7 ; ##...###
                        dc.b $cf ; ##..####
                        dc.b $ff ; ########
                        
HillChar2b              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $3c ; ..####..
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
HillChar2c              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        
HillChar2d              dc.b $a5 ; #.#..#.#
                        dc.b $a5 ; #.#..#.#
                        dc.b $a7 ; #.#..###
                        dc.b $93 ; #..#..##
                        dc.b $93 ; #..#..##
                        dc.b $4f ; .#..####
                        dc.b $4f ; .#..####
                        dc.b $4f ; .#..####
                        
HillChar2e              dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $f7 ; ####.###
                        dc.b $ff ; ########
                        dc.b $fb ; #####.##
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        
HillChar2f              dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $e7 ; ###..###
                        
HillChar30              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f1 ; ####...#
                        dc.b $c7 ; ##...###
                        dc.b $8f ; #...####
                        
HillChar31              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $e0 ; ###.....
                        dc.b $0f ; ....####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar32              dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $2f ; ..#.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar33              dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
HillChar34              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $3a ; ..###.#.
                        dc.b $32 ; ..##..#.
                        dc.b $3e ; ..#####.
                        
HillChar35              dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $fa ; #####.#.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f1 ; ####...#
                        dc.b $c5 ; ##...#.#
                        
HillChar36              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $f1 ; ####...#
                        dc.b $15 ; ...#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $51 ; .#.#...#
                        
HillChar37              dc.b $a8 ; #.#.#...
                        dc.b $a1 ; #.#....#
                        dc.b $85 ; #....#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $45 ; .#...#.#
                        dc.b $51 ; .#.#...#
                        dc.b $45 ; .#...#.#
                        dc.b $55 ; .#.#.#.#
                        
HillChar38              dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
HillChar39              dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $ab ; #.#.#.##
                        dc.b $eb ; ###.#.##
                        dc.b $eb ; ###.#.##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar3a              dc.b $fc ; ######..
                        dc.b $99 ; #..##..#
                        dc.b $aa ; #.#.#.#.
                        dc.b $d7 ; ##.#.###
                        dc.b $d7 ; ##.#.###
                        dc.b $f7 ; ####.###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar3b              dc.b $8f ; #...####
                        dc.b $c7 ; ##...###
                        dc.b $8f ; #...####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar3c              dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $cf ; ##..####
                        dc.b $8f ; #...####
                        dc.b $8f ; #...####
                        dc.b $bf ; #.######
                        
HillChar3d              dc.b $32 ; ..##..#.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
HillChar3e              dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2b ; ..#.#.##
                        dc.b $6f ; .##.####
                        dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        
HillChar3f              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        
HillChar40              dc.b $d5 ; ##.#.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $45 ; .#...#.#
                        dc.b $51 ; .#.#...#
                        dc.b $51 ; .#.#...#
                        dc.b $51 ; .#.#...#
                        dc.b $54 ; .#.#.#..
                        dc.b $54 ; .#.#.#..
                        
HillChar41              dc.b $e3 ; ###...##
                        dc.b $c3 ; ##....##
                        dc.b $c7 ; ##...###
                        dc.b $d7 ; ##.#.###
                        dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        
HillChar42              dc.b $7d ; .#####.#
                        dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar43              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f1 ; ####...#
                        dc.b $e3 ; ###...##
                        dc.b $cf ; ##..####
                        
HillChar44              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        dc.b $ff ; ########
                        
HillChar45              dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $ff ; ########
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
HillChar46              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f9 ; #####..#
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $cf ; ##..####
                        dc.b $ff ; ########
                        
HillChar47              dc.b $ff ; ########
                        dc.b $cf ; ##..####
                        dc.b $e7 ; ###..###
                        dc.b $e3 ; ###...##
                        dc.b $c7 ; ##...###
                        dc.b $cf ; ##..####
                        dc.b $9f ; #..#####
                        dc.b $ff ; ########
                        
HillChar48              dc.b $ff ; ########
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d7 ; ##.#.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        
HillChar49              dc.b $7f ; .#######
                        dc.b $5f ; .#.#####
                        dc.b $4f ; .#..####
                        dc.b $57 ; .#.#.###
                        dc.b $57 ; .#.#.###
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
HillChar4a              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f1 ; ####...#
                        dc.b $c5 ; ##...#.#
                        dc.b $d5 ; ##.#.#.#
                        
HillChar4b              dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
HillChar4c              dc.b $5f ; .#.#####
                        dc.b $57 ; .#.#.###
                        dc.b $5f ; .#.#####
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
HillChar4d              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f9 ; #####..#
                        dc.b $f2 ; ####..#.
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        
HillChar4e              dc.b $cf ; ##..####
                        dc.b $8f ; #...####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        
HillChar4f              dc.b $ff ; ########
                        dc.b $f7 ; ####.###
                        dc.b $d7 ; ##.#.###
                        dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar50              dc.b $cf ; ##..####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $eb ; ###.#.##
                        dc.b $af ; #.#.####
                        dc.b $bf ; #.######
                        
HillChar51              dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e7 ; ###..###
                        dc.b $ef ; ###.####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar52              dc.b $3f ; ..######
                        dc.b $9f ; #..#####
                        dc.b $cf ; ##..####
                        dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $cf ; ##..####
                        dc.b $9f ; #..#####
                        dc.b $bf ; #.######
                        
HillChar53              dc.b $fc ; ######..
                        dc.b $f1 ; ####...#
                        dc.b $e1 ; ###....#
                        dc.b $c3 ; ##....##
                        dc.b $cf ; ##..####
                        dc.b $df ; ##.#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar54              dc.b $e7 ; ###..###
                        dc.b $f3 ; ####..##
                        dc.b $f9 ; #####..#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar55              dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $14 ; ...#.#..
                        dc.b $17 ; ...#.###
                        dc.b $17 ; ...#.###
                        dc.b $45 ; .#...#.#
                        dc.b $f7 ; ####.###
                        
HillChar56              dc.b $44 ; .#...#..
                        dc.b $53 ; .#.#..##
                        dc.b $57 ; .#.#.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $45 ; .#...#.#
                        dc.b $53 ; .#.#..##
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        
HillChar57              dc.b $05 ; .....#.#
                        dc.b $05 ; .....#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
HillChar58              dc.b $df ; ##.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar59              dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $e7 ; ###..###
                        dc.b $cf ; ##..####
                        dc.b $9f ; #..#####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar5a              dc.b $3f ; ..######
                        dc.b $5f ; .#.#####
                        dc.b $d7 ; ##.#.###
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $57 ; .#.#.###
                        dc.b $5f ; .#.#####
                        
HillChar5b              dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar5c              dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $ff ; ########
                        
HillChar5d              dc.b $40 ; .#......
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $14 ; ...#.#..
                        dc.b $15 ; ...#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        
HillChar5e              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $4f ; .#..####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
HillChar5f              dc.b $44 ; .#...#..
                        dc.b $44 ; .#...#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar60              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
HillChar61              dc.b $fd ; ######.#
                        dc.b $f1 ; ####...#
                        dc.b $f5 ; ####.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $f1 ; ####...#
                        dc.b $ff ; ########
                        
HillChar62              dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        
HillChar63              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f5 ; ####.#.#
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $d5 ; ##.#.#.#
                        
HillChar64              dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7e ; .######.
                        dc.b $7d ; .#####.#
                        
HillChar65              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $c3 ; ##....##
                        
HillChar66              dc.b $e7 ; ###..###
                        dc.b $e7 ; ###..###
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $9f ; #..#####
                        dc.b $9f ; #..#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        
HillChar67              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $e7 ; ###..###
                        dc.b $c7 ; ##...###
                        dc.b $8f ; #...####
                        dc.b $8f ; #...####
                        
HillChar68              dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $e7 ; ###..###
                        dc.b $f3 ; ####..##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar69              dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $f1 ; ####...#
                        dc.b $f1 ; ####...#
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar6a              dc.b $7f ; .#######
                        dc.b $5f ; .#.#####
                        dc.b $4f ; .#..####
                        dc.b $57 ; .#.#.###
                        dc.b $57 ; .#.#.###
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $57 ; .#.#.###
                        
HillChar6b              dc.b $c4 ; ##...#..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar6c              dc.b $17 ; ...#.###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar6d              dc.b $d1 ; ##.#...#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar6e              dc.b $51 ; .#.#...#
                        dc.b $d3 ; ##.#..##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar6f              dc.b $5f ; .#.#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar70              dc.b $15 ; ...#.#.#
                        dc.b $f3 ; ####..##
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar71              dc.b $4d ; .#..##.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar72              dc.b $d5 ; ##.#.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar73              dc.b $55 ; .#.#.#.#
                        dc.b $d7 ; ##.#.###
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar74              dc.b $c5 ; ##...#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar75              dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar76              dc.b $05 ; .....#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar77              dc.b $f5 ; ####.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar78              dc.b $55 ; .#.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar79              dc.b $55 ; .#.#.#.#
                        dc.b $5f ; .#.#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
HillChar7a              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
HillChar7b              dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
HillChar7c              dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
HillChar7d              dc.b $50 ; .#.#....
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
; Intro screen graphics data
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataIntro         equ  *   ; 
A_afec                  dc.b $09 ; unused
                        dc.b YELLOW ; --> TabBackGroundColor
                        dc.b $02 ; --> BGCOL1
                        dc.b $05 ; --> BGCOL2
                        
A_aff0                  dc.b $ff ; end of data
                        
                        dc.b $01 ; 
                        dc.b $03 ; 
                        dc.b $78 ; 
                        dc.b $02 ; 
                        dc.b $0b ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $04 ; 
                        dc.b $0b ; 
                        dc.b $05 ; 
                        dc.b $0b ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0b ; 
A_b000                  dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $09 ; 
                        dc.b $0b ; 
                        dc.b $0a ; 
                        dc.b $0b ; 
                        dc.b $02 ; 
                        dc.b $0b ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $04 ; 
                        dc.b $0b ; 
A_b010                  dc.b $05 ; 
                        dc.b $0b ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $09 ; 
                        dc.b $0b ; 
                        dc.b $0a ; 
                        dc.b $0b ; 
                        dc.b $02 ; 
                        dc.b $0b ; 
                        dc.b $03 ; 
                        dc.b $0b ; 
A_b020                  dc.b $04 ; 
                        dc.b $0b ; 
                        dc.b $05 ; 
                        dc.b $0b ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $09 ; 
                        dc.b $0b ; 
                        dc.b $0a ; 
                        dc.b $0b ; 
                        dc.b $02 ; 
                        dc.b $0b ; 
A_b030                  dc.b $03 ; 
                        dc.b $0b ; 
                        dc.b $04 ; 
                        dc.b $0b ; 
                        dc.b $05 ; 
                        dc.b $0b ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $07 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $1e ; 
                        dc.b $0b ; 
                        dc.b $1f ; 
                        dc.b $0b ; 
A_b040                  dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $01 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $01 ; 
                        dc.b $05 ; 
                        dc.b $20 ; 
                        dc.b $21 ; 
                        dc.b $08 ; 
                        dc.b $22 ; 
                        dc.b $08 ; 
                        dc.b $23 ; 
                        dc.b $08 ; 
                        dc.b $24 ; 
                        dc.b $08 ; 
A_b050                  dc.b $25 ; 
                        dc.b $0e ; 
                        dc.b $26 ; 
                        dc.b $0e ; 
                        dc.b $27 ; 
                        dc.b $06 ; 
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $0c ; 
                        dc.b $08 ; 
                        dc.b $0d ; 
                        dc.b $08 ; 
                        dc.b $0e ; 
                        dc.b $08 ; 
A_b060                  dc.b $0f ; 
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $08 ; 
                        dc.b $11 ; 
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $08 ; 
                        dc.b $11 ; 
                        dc.b $08 ; 
                        dc.b $12 ; 
                        dc.b $08 ; 
                        dc.b $13 ; 
                        dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
A_b070                  dc.b $0c ; 
                        dc.b $08 ; 
                        dc.b $0d ; 
                        dc.b $08 ; 
                        dc.b $0e ; 
                        dc.b $08 ; 
                        dc.b $0f ; 
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $08 ; 
                        dc.b $11 ; 
                        dc.b $08 ; 
                        dc.b $12 ; 
                        dc.b $08 ; 
                        dc.b $13 ; 
                        dc.b $08 ; 
A_b080                  dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $0c ; 
                        dc.b $08 ; 
                        dc.b $0d ; 
                        dc.b $08 ; 
                        dc.b $0e ; 
                        dc.b $08 ; 
                        dc.b $0f ; 
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $08 ; 
                        dc.b $11 ; 
                        dc.b $08 ; 
                        dc.b $12 ; 
                        dc.b $08 ; 
A_b090                  dc.b $13 ; 
                        dc.b $08 ; 
                        dc.b $0b ; 
                        dc.b $08 ; 
                        dc.b $41 ; 
                        dc.b $08 ; 
                        dc.b $28 ; 
                        dc.b $08 ; 
                        dc.b $29 ; 
                        dc.b $08 ; 
                        dc.b $2a ; 
                        dc.b $08 ; 
                        dc.b $2b ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
A_b0a0                  dc.b $08 ; 
                        dc.b $02 ; 
                        dc.b $2d ; 
                        dc.b $06 ; 
                        dc.b $2e ; 
                        dc.b $06 ; 
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $14 ; 
                        dc.b $08 ; 
                        dc.b $15 ; 
                        dc.b $08 ; 
                        dc.b $16 ; 
                        dc.b $08 ; 
                        dc.b $17 ; 
                        dc.b $08 ; 
A_b0b0                  dc.b $18 ; 
                        dc.b $08 ; 
                        dc.b $19 ; 
                        dc.b $08 ; 
                        dc.b $1a ; 
                        dc.b $08 ; 
                        dc.b $19 ; 
                        dc.b $08 ; 
                        dc.b $1a ; 
                        dc.b $08 ; 
                        dc.b $1b ; 
                        dc.b $08 ; 
                        dc.b $1c ; 
                        dc.b $08 ; 
                        dc.b $14 ; 
                        dc.b $08 ; 
A_b0c0                  dc.b $15 ; 
                        dc.b $08 ; 
                        dc.b $16 ; 
                        dc.b $08 ; 
                        dc.b $17 ; 
                        dc.b $08 ; 
                        dc.b $18 ; 
                        dc.b $08 ; 
                        dc.b $19 ; 
                        dc.b $08 ; 
                        dc.b $1a ; 
                        dc.b $08 ; 
                        dc.b $1b ; 
                        dc.b $08 ; 
                        dc.b $1c ; 
                        dc.b $08 ; 
A_b0d0                  dc.b $14 ; 
                        dc.b $08 ; 
                        dc.b $15 ; 
                        dc.b $08 ; 
                        dc.b $16 ; 
                        dc.b $08 ; 
                        dc.b $17 ; 
                        dc.b $08 ; 
                        dc.b $18 ; 
                        dc.b $08 ; 
                        dc.b $19 ; 
                        dc.b $08 ; 
                        dc.b $1a ; 
                        dc.b $08 ; 
                        dc.b $1b ; 
                        dc.b $08 ; 
A_b0e0                  dc.b $1c ; 
                        dc.b $08 ; 
                        dc.b $14 ; 
                        dc.b $08 ; 
                        dc.b $40 ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $04 ; 
                        dc.b $30 ; 
                        dc.b $06 ; 
                        dc.b $2f ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
A_b0f0                  dc.b $06 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $20 ; 
                        dc.b $33 ; 
                        dc.b $06 ; 
                        dc.b $32 ; 
                        dc.b $06 ; 
                        dc.b $31 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $05 ; 
A_b100                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $1e ; 
                        dc.b $35 ; 
                        dc.b $06 ; 
                        dc.b $34 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $1d ; 
A_b110                  dc.b $36 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $0a ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $04 ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $8a ; 
                        dc.b $00 ; 
                        dc.b $8d ; 
                        dc.b $00 ; 
A_b120                  dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $90 ; 
                        dc.b $00 ; 
                        dc.b $91 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $96 ; 
                        dc.b $00 ; 
                        dc.b $97 ; 
                        dc.b $00 ; 
                        dc.b $98 ; 
                        dc.b $00 ; 
A_b130                  dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $9f ; 
                        dc.b $00 ; 
                        dc.b $a0 ; 
                        dc.b $00 ; 
                        dc.b $a1 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
A_b140                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $37 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $04 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
A_b150                  dc.b $8b ; 
                        dc.b $00 ; 
                        dc.b $8e ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
                        dc.b $92 ; 
                        dc.b $00 ; 
                        dc.b $93 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $99 ; 
                        dc.b $00 ; 
A_b160                  dc.b $9a ; 
                        dc.b $00 ; 
                        dc.b $9b ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $a2 ; 
                        dc.b $00 ; 
                        dc.b $a3 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $02 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
A_b170                  dc.b $a7 ; 
                        dc.b $00 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $a7 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $03 ; 
                        dc.b $38 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
A_b180                  dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $04 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
                        dc.b $8c ; 
                        dc.b $00 ; 
                        dc.b $8f ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
A_b190                  dc.b $94 ; 
                        dc.b $00 ; 
                        dc.b $95 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $9c ; 
                        dc.b $00 ; 
                        dc.b $9d ; 
                        dc.b $00 ; 
                        dc.b $9e ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $a4 ; 
                        dc.b $00 ; 
A_b1a0                  dc.b $a5 ; 
                        dc.b $00 ; 
                        dc.b $a6 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
A_b1b0                  dc.b $39 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $0b ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $04 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $ab ; 
                        dc.b $02 ; 
                        dc.b $15 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
A_b1c0                  dc.b $05 ; 
                        dc.b $04 ; 
                        dc.b $3a ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $0a ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $0c ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
A_b1d0                  dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $90 ; 
                        dc.b $00 ; 
                        dc.b $91 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $96 ; 
                        dc.b $00 ; 
                        dc.b $97 ; 
                        dc.b $00 ; 
A_b1e0                  dc.b $98 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $87 ; 
                        dc.b $00 ; 
                        dc.b $8a ; 
                        dc.b $00 ; 
                        dc.b $a9 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $03 ; 
                        dc.b $3b ; 
                        dc.b $06 ; 
A_b1f0                  dc.b $3c ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $0c ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
                        dc.b $a7 ; 
                        dc.b $00 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
A_b200                  dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
                        dc.b $92 ; 
                        dc.b $00 ; 
                        dc.b $93 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $99 ; 
                        dc.b $00 ; 
                        dc.b $9a ; 
                        dc.b $00 ; 
                        dc.b $9b ; 
                        dc.b $00 ; 
A_b210                  dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $88 ; 
                        dc.b $00 ; 
                        dc.b $a8 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $3d ; 
                        dc.b $06 ; 
                        dc.b $3e ; 
                        dc.b $06 ; 
A_b220                  dc.b $3f ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $05 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $0c ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
A_b230                  dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
                        dc.b $94 ; 
                        dc.b $00 ; 
                        dc.b $95 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $9c ; 
                        dc.b $00 ; 
                        dc.b $9d ; 
                        dc.b $00 ; 
                        dc.b $9e ; 
                        dc.b $00 ; 
A_b240                  dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $89 ; 
                        dc.b $00 ; 
                        dc.b $8c ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $00 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $05 ; 
A_b250                  dc.b $42 ; 
                        dc.b $06 ; 
                        dc.b $43 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $03 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $0c ; 
                        dc.b $ff ; end of data
                        
                        dc.b $ab ; 
                        dc.b $02 ; 
                        dc.b $0f ; 
A_b260                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $05 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $03 ; 
                        dc.b $44 ; 
                        dc.b $06 ; 
                        dc.b $45 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $03 ; 
A_b270                  dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $05 ; 
                        dc.b $1e ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $07 ; 
                        dc.b $46 ; 
                        dc.b $06 ; 
                        dc.b $47 ; 
                        dc.b $06 ; 
                        dc.b $86 ; 
                        dc.b $06 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
A_b280                  dc.b $05 ; 
                        dc.b $20 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $08 ; 
                        dc.b $ff ; end of data
                        
                        dc.b $ff ; end of screen
; -------------------------------------------------------------------------------------------------------------- ;
; Intro screen charset data part 2: Text
; -------------------------------------------------------------------------------------------------------------- ;
ScreenCharIntro         equ  *   ; 
A_b288                  dc.b $25 ; --> count       
                        dc.b $87 ; --> BH_Scrn_GfxCharSets offset lo / $08
                        
BayTextChar00           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayTextChar01           dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayTextChar02           dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar03           dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar04           dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar05           dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayTextChar06           dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar07           dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
BayTextChar08           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        
BayTextChar09           dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar0a           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar0b           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar0c           dc.b $38 ; ..###...
                        dc.b $78 ; .####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $78 ; .####...
                        dc.b $38 ; ..###...
                        
BayTextChar0d           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayTextChar0e           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar0f           dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar10           dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $cf ; ##..####
                        dc.b $87 ; #....###
                        dc.b $87 ; #....###
                        
BayTextChar11           dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        
BayTextChar12           dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $1e ; ...####.
                        dc.b $1e ; ...####.
                        dc.b $1e ; ...####.
                        dc.b $3c ; ..####..
                        
BayTextChar13           dc.b $87 ; #....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
BayTextChar14           dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
BayTextChar15           dc.b $3c ; ..####..
                        dc.b $3c ; ..####..
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $78 ; .####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
BayTextChar16           dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar17           dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $3e ; ..#####.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayTextChar18           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
BayTextChar19           dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayTextChar1a           dc.b $3c ; ..####..
                        dc.b $3e ; ..#####.
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar1v           dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
BayTextChar1c           dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayTextChar1d           dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar1e           dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        
BayTextChar1f           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $3e ; ..#####.
                        dc.b $3c ; ..####..
                        
BayTextChar20           dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayTextChar21           dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        
BayTextChar22           dc.b $00 ; ........
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        
BayTextChar23           dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        
BayTextChar24           dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
TabTankScrollAreaData   equ  *   ; 
T_b3b2                  dc.b $0a ; --> BH_TabTankObstPosY 
                        dc.b $7a ; --> BH_TabTankObstChrNum in ScreenDataBayShore
                        dc.b RED ; --> BH_TabTankObstColor
                        
                        dc.b $0b ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $0d ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $0f ; 
                        dc.b $80 ; 
                        dc.b RED ; 
                        
                        dc.b $10 ; 
                        dc.b $7e ; 
                        dc.b RED ; 
                        
                        dc.b $11 ; 
                        dc.b $85 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b3c4                  dc.b $0b ; 
                        dc.b $7c ; 
                        dc.b RED ; 
                        
                        dc.b $0c ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $0e ; 
                        dc.b $7e ; 
                        dc.b RED ; 
                        
                        dc.b $0f ; 
                        dc.b $7b ; 
                        dc.b RED ; 
                        
                        dc.b $10 ; 
                        dc.b $83 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b3d3                  dc.b $0c ; 
                        dc.b $7d ; 
                        dc.b RED ; 
                        
                        dc.b $0d ; 
                        dc.b $7e ; 
                        dc.b RED ; 
                        
                        dc.b $0e ; 
                        dc.b $80 ; 
                        dc.b RED ; 
                        
                        dc.b $0f ; 
                        dc.b $82 ; 
                        dc.b RED ; 
                        
                        dc.b $10 ; 
                        dc.b $84 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b3e2                  dc.b $0d ; 
                        dc.b $7f ; 
                        dc.b RED ; 
                        
                        dc.b $0e ; 
                        dc.b $81 ; 
                        dc.b [$80 | RED] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b3e8                  dc.b $11 ; 
                        dc.b $b2 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $b6 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b3ee                  dc.b $08 ; 
                        dc.b $6c ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $6e ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $70 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $72 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $74 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $79 ; 
                        dc.b BROWN ; 
                        
                        dc.b $10 ; 
                        dc.b $ae ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $11 ; 
                        dc.b $b3 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $b9 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b40c                  dc.b $08 ; 
                        dc.b $6d ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $6f ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $71 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $73 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $77 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $b4 ; 
                        dc.b BROWN ; 
                        
                        dc.b $10 ; 
                        dc.b $af ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $11 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $75 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b42d                  dc.b $0c ; 
                        dc.b $76 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $ac ; 
                        dc.b BROWN ; 
                        
                        dc.b $10 ; 
                        dc.b $b0 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $11 ; 
                        dc.b $b5 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $b8 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $ba ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b442                  dc.b $0d ; 
                        dc.b $78 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $ad ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $b1 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $13 ; 
                        dc.b $bb ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b44e                  dc.b $0c ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b451                  dc.b $11 ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b457                  dc.b $11 ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b45a                  dc.b $0c ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b460                  dc.b $0c ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b463                  dc.b $12 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b466                  dc.b [COLORAM_MCM_On | WHITE] ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b469                  dc.b $0e ; 
                        dc.b $4b ; 
                        dc.b BLACK ; 
                        
                        dc.b $0f ; 
                        dc.b $4e ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b46f                  dc.b $0d ; 
                        dc.b $49 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0e ;
                        dc.b $4c ; 
                        dc.b BLACK ; 
                        
                        dc.b $0f ; 
                        dc.b $4f ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b478                  dc.b $0d ; 
                        dc.b $4a ; 
                        dc.b BLACK ; 
                        
                        dc.b $0e ; 
                        dc.b $4d ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b47e                  dc.b $11 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b481                  dc.b $0a ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b484                  dc.b $0b ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $60 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $59 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b490                  dc.b $0b ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $5d ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $5a ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b49c                  dc.b $0b ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $5e ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $62 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4a8                  dc.b $09 ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $60 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $59 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4b4                  dc.b $09 ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $5d ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $5a ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4c0                  dc.b $09 ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $5e ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $60 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $59 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $62 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4db                  dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $5d ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5a ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4e7                  dc.b $0c ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $5e ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $62 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4f3                  dc.b $0c ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $59 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b4ff                  dc.b $0c ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $5a ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b50b                  dc.b $09 ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $59 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $62 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5e ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b526                  dc.b $09 ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $5a ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b532                  dc.b $09 ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $62 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $5e ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b53e                  dc.b $0b ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $59 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b54a                  dc.b $0b ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $5a ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b556                  dc.b $0b ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $62 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $5e ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b562                  dc.b $0c ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b568                  dc.b $0e ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b56e                  dc.b $0e ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b571                  dc.b $0c ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b577                  dc.b $09 ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $59 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $59 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b583                  dc.b $09 ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $5a ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5a ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b58f                  dc.b $09 ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $62 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $62 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b59b                  dc.b $0c ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $0d ; 
                        dc.b $60 ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $12 ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $13 ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | CYAN] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5a7                  dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $0d ; 
                        dc.b $5d ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $12 ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $13 ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | CYAN] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5b3                  dc.b $0c ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $0d ; 
                        dc.b $5e ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $12 ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $13 ; 
                        dc.b $5e ; 
                        dc.b [$80 | COLORAM_MCM_On | CYAN] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5bf                  dc.b $0b ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5c8                  dc.b $0d ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5cb                  dc.b $09 ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0a ; 
                        dc.b $65 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $10 ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5d7                  dc.b $09 ; 
                        dc.b $64 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $10 ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5dd                  dc.b $09 ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0e ; 
                        dc.b $65 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5e9                  dc.b $0d ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5ec                  dc.b $0a ; 
                        dc.b $50 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0b ; 
                        dc.b $52 ; 
                        dc.b BLACK ; 
                        
                        dc.b $10 ; 
                        dc.b $4b ; 
                        dc.b BLACK ; 
                        
                        dc.b $11 ; 
                        dc.b $4e ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b5f8                  dc.b $0a ; 
                        dc.b $51 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0b ; 
                        dc.b $53 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0c ; 
                        dc.b $55 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0f ; 
                        dc.b $49 ; 
                        dc.b BLACK ; 
                        
                        dc.b $10 ; 
                        dc.b $4c ; 
                        dc.b BLACK ; 
                        
                        dc.b $11 ; 
                        dc.b $4f ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b60a                  dc.b $0b ; 
                        dc.b $54 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0c ; 
                        dc.b $56 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0f ; 
                        dc.b $4a ; 
                        dc.b BLACK ; 
                        
                        dc.b $10 ; 
                        dc.b $4d ; 
                        dc.b BLACK ; 
                        
                        dc.b $13 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b619                  dc.b $0a ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b61c                  dc.b $0c ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b622                  dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b628                  dc.b $0c ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0d ; 
                        dc.b $5e ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b62e                  dc.b $12 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b631                  dc.b $0b ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b637                  dc.b $0b ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b63a                  dc.b $0e ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $0f ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | CYAN] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b640                  dc.b $09 ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $0f ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | CYAN] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b649                  dc.b $0e ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $0f ; 
                        dc.b $5e ; 
                        dc.b [$80 | COLORAM_MCM_On | CYAN] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b64f                  dc.b $13 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b652                  dc.b $0b ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b655                  dc.b $11 ; 
                        dc.b $b2 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $b6 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b65b                  dc.b $08 ; 
                        dc.b $6c ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $6e ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $70 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $72 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $74 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $79 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $ae ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $11 ; 
                        dc.b $b3 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $b9 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b679                  dc.b $08 ; 
                        dc.b $6d ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $6f ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $71 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $73 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $77 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $b4 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $af ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $11 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $75 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b69a                  dc.b $0c ; 
                        dc.b $76 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $75 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $ac ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $b0 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $11 ; 
                        dc.b $b5 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $b8 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $ba ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6af                  dc.b $0d ; 
                        dc.b $78 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $ad ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $b1 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $13 ; 
                        dc.b $bb ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6bb                  dc.b $0d ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6be                  dc.b $11 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6c1                  dc.b $0a ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0b ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6c7                  dc.b $0a ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6ca                  dc.b $0f ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $59 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6d0                  dc.b $0f ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5a ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6d6                  dc.b $0f ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $62 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6dc                  dc.b $09 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6df                  dc.b $0a ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0b ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6e5                  dc.b $0a ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0b ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6eb                  dc.b $0a ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0b ; 
                        dc.b $5e ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0f ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6f4                  dc.b $11 ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $12 ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6fa                  dc.b $11 ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b6fd                  dc.b $0a ; 
                        dc.b $4b ; 
                        dc.b BLACK ; 
                        
                        dc.b $0b ; 
                        dc.b $4e ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b703                  dc.b $09 ; 
                        dc.b $49 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0a ; 
                        dc.b $4c ; 
                        dc.b BLACK ; 
                        
                        dc.b $0b ; 
                        dc.b $4f ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b70c                  dc.b $09 ; 
                        dc.b $4a ; 
                        dc.b BLACK ; 
                        
                        dc.b $0a ; 
                        dc.b $4d ; 
                        dc.b BLACK ; 
                        
                        dc.b $12 ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b715                  dc.b $0d ; 
                        dc.b $50 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0e ; 
                        dc.b $52 ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b71b                  dc.b $0d ; 
                        dc.b $51 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0e ; 
                        dc.b $53 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0f ; 
                        dc.b $55 ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b724                  dc.b $0e ; 
                        dc.b $54 ; 
                        dc.b BLACK ; 
                        
                        dc.b $0f ; 
                        dc.b $56 ; 
                        dc.b [$80 | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b72a                  dc.b $0b ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b72d                  dc.b $0b ; 
                        dc.b $57 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $59 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5f ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $60 ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b739                  dc.b $0b ; 
                        dc.b $58 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $5a ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5b ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $5d ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b745                  dc.b $0b ; 
                        dc.b $61 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $0c ; 
                        dc.b $62 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $10 ; 
                        dc.b $5c ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $11 ; 
                        dc.b $5e ; 
                        dc.b [$80 | COLORAM_MCM_On | WHITE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b751                  dc.b $09 ; 
                        dc.b $48 ; mine
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $63 ; 
                        dc.b [COLORAM_MCM_On | WHITE] ; 
                        
                        dc.b $13 ; 
                        dc.b $65 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b75a                  dc.b $12 ; 
                        dc.b $64 ; 
                        dc.b [$80 | COLORAM_MCM_On | BLACK] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b75d                  dc.b $0f ; 
                        dc.b $48 ; mine
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b760                  dc.b $0c ; 
                        dc.b $37 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $38 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $39 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b769                  dc.b $0b ; 
                        dc.b $36 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $3a ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b778                  dc.b $07 ; 
                        dc.b $41 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $08 ; 
                        dc.b $40 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $0a ; 
                        dc.b $35 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $3b ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b793                  dc.b $07 ; 
                        dc.b $28 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $0a ; 
                        dc.b $34 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $3c ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b7ab                  dc.b $06 ; 
                        dc.b $21 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $07 ; 
                        dc.b $29 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $33 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $3d ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b7cc                  dc.b $06 ; 
                        dc.b $22 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $07 ; 
                        dc.b $2a ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $32 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $3e ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b7ed                  dc.b $06 ; 
                        dc.b $23 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $07 ; 
                        dc.b $2b ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $09 ; 
                        dc.b $31 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $3f ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b80e                  dc.b $06 ; 
                        dc.b $24 ; 
                        dc.b [COLORAM_MCM_On | BLACK] ; 
                        
                        dc.b $08 ; 
                        dc.b $30 ; 
                        dc.b BLUE ; 
                        
                        dc.b $09 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $42 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $44 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b835                  dc.b $05 ; 
                        dc.b $1e ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $06 ; 
                        dc.b $25 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $08 ; 
                        dc.b $2f ; 
                        dc.b BLUE ; 
                        
                        dc.b $09 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $43 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $45 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b85f                  dc.b $05 ; 
                        dc.b $1f ; 
                        dc.b [COLORAM_MCM_On | CYAN] ;
                        
                        dc.b $06 ; 
                        dc.b $26 ; 
                        dc.b [COLORAM_MCM_On | BLUE] ;
                        
                        dc.b $07 ; 
                        dc.b $2d ; 
                        dc.b BLUE ; 
                        
                        dc.b $08 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $09 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $86 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b88c                  dc.b $05 ; 
                        dc.b $20 ; 
                        dc.b CYAN ; 
                        
                        dc.b $06 ; 
                        dc.b $27 ; 
                        dc.b BLUE ; 
                        
                        dc.b $07 ; 
                        dc.b $2e ; 
                        dc.b BLUE ; 
                        
                        dc.b $08 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $09 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $86 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
T_b8b9                  dc.b $05 ; 
                        dc.b $86 ; 
                        dc.b CYAN ; 
                        
                        dc.b $06 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $07 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $08 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $09 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0a ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0b ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0c ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0d ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0e ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $0f ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $10 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $11 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $12 ; 
                        dc.b $86 ; 
                        dc.b BLUE ; 
                        
                        dc.b $13 ; 
                        dc.b $86 ; 
                        dc.b [$80 | BLUE] ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; Intro/Tank screen charset data part 1: Bay Shore
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataBayShore      dc.b $87 ; --> count
                        dc.b $00 ; --> BH_Scrn_GfxCharSets offset lo / $08
                        
BayShoreChar00          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar01          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar02          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $ba ; #.###.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar03          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $ba ; #.###.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar04          dc.b $fe ; #######.
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar05          dc.b $bf ; #.######
                        dc.b $ae ; #.#.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar06          dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ae ; #.#.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar07          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar08          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fa ; #####.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar09          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $ab ; #.#.#.##
                        
BayShoreChar0a          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $eb ; ###.#.##
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar0b          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $b7 ; #.##.###
                        
BayShoreChar0c          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $77 ; .###.###
                        
BayShoreChar0d          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        
BayShoreChar0e          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar0f          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $7a ; .####.#.
                        dc.b $7e ; .######.
                        
BayShoreChar10          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ae ; #.#.###.
                        dc.b $b7 ; #.##.###
                        
BayShoreChar11          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        
BayShoreChar12          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $be ; #.#####.
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar13          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $7a ; .####.#.
                        dc.b $76 ; .###.##.
                        
BayShoreChar14          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $30 ; ..##....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar15          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar16          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $33 ; ..##..##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar17          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar18          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar19          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $04 ; .....#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1a          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1b          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1c          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1d          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar1e          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        
BayShoreChar1f          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $00 ; ........
                        
BayShoreChar20          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        
BayShoreChar21          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $a7 ; #.#..###
                        dc.b $b7 ; #.##.###
                        dc.b $b7 ; #.##.###
                        
BayShoreChar22          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar23          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar24          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        dc.b $40 ; .#......
                        
BayShoreChar25          dc.b $80 ; #.......
                        dc.b $83 ; #.....##
                        dc.b $bf ; #.######
                        dc.b $bf ; #.######
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar26          dc.b $00 ; ........
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar27          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
BayShoreChar28          dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $af ; #.#.####
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        
BayShoreChar29          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $70 ; .###....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2a          dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2b          dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2c          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar2d          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
BayShoreChar2e          dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar2f          dc.b $07 ; .....###
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar30          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        
BayShoreChar31          dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar32          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar33          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $7f ; .#######
                        
BayShoreChar34          dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar35          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $ff ; ########
                        
BayShoreChar36          dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar37          dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar38          dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar39          dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        
BayShoreChar3a          dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        
BayShoreChar3b          dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar3c          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $03 ; ......##
                        
BayShoreChar3d          dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar3e          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar3f          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $0f ; ....####
                        
BayShoreChar40          dc.b $77 ; .###.###
                        dc.b $70 ; .###....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar41          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ab ; #.#.#.##
                        dc.b $b7 ; #.##.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        
BayShoreChar42          dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar43          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $7f ; .#######
                        
BayShoreChar44          dc.b $00 ; ........
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar45          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $1f ; ...#####
                        
BayShoreChar46          dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar47          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $00 ; ........
                        
BayShoreChar48          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar49          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        
BayShoreChar4a          dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
BayShoreChar4b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $07 ; .....###
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        
BayShoreChar4c          dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        
BayShoreChar4d          dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        
BayShoreChar4e          dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $3e ; ..#####.
                        dc.b $1c ; ...###..
                        dc.b $00 ; ........
                        
BayShoreChar4f          dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar50          dc.b $70 ; .###....
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        
BayShoreChar51          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        
BayShoreChar52          dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar53          dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayShoreChar54          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        
BayShoreChar55          dc.b $7f ; .#######
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar56          dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $78 ; .####...
                        dc.b $00 ; ........
                        
BayShoreChar57          dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        
BayShoreChar58          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $ab ; #.#.#.##
                        
BayShoreChar59          dc.b $02 ; ......#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5a          dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $02 ; ......#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5b          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        
BayShoreChar5c          dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $50 ; .#.#....
                        
BayShoreChar5d          dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $54 ; .#.#.#..
                        dc.b $50 ; .#.#....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5e          dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar5f          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        
BayShoreChar60          dc.b $3f ; ..######
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f4 ; ####.#..
                        dc.b $00 ; ........
                        
BayShoreChar61          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        
BayShoreChar62          dc.b $fc ; ######..
                        dc.b $bf ; #.######
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $af ; #.#.####
                        dc.b $2f ; ..#.####
                        dc.b $00 ; ........
                        
BayShoreChar63          dc.b $01 ; .......#
                        dc.b $05 ; .....#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $35 ; ..##.#.#
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
                        
BayShoreChar64          dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $70 ; .###....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        
BayShoreChar65          dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar66          dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar67          dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $7d ; .#####.#
                        dc.b $1f ; ...#####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
BayShoreChar68          dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $7d ; .#####.#
                        
BayShoreChar69          dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        dc.b $55 ; .#.#.#.#
                        
BayShoreChar6a          dc.b $55 ; .#.#.#.#
                        dc.b $57 ; .#.#.###
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        
BayShoreChar6b          dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        
BayShoreChar6c          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $37 ; ..##.###
                        dc.b $07 ; .....###
                        
BayShoreChar6d          dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $77 ; .###.###
                        dc.b $74 ; .###.#..
                        dc.b $74 ; .###.#..
                        dc.b $f0 ; ####....
                        
BayShoreChar6e          dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $07 ; .....###
                        
BayShoreChar6f          dc.b $7c ; .#####..
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
BayShoreChar70          dc.b $07 ; .....###
                        dc.b $0f ; ....####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar71          dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
BayShoreChar72          dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        
BayShoreChar73          dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar74          dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
BayShoreChar75          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
BayShoreChar76          dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $f8 ; #####...
                        dc.b $ff ; ########
                        
BayShoreChar77          dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $3f ; ..######
                        dc.b $3f ; ..######
                        
BayShoreChar78          dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayShoreChar79          dc.b $0a ; ....#.#.
                        dc.b $05 ; .....#.#
                        dc.b $05 ; .....#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar7a          dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        
BayShoreChar7b          dc.b $ff ; ########
                        dc.b $9b ; #..##.##
                        dc.b $cf ; ##..####
                        dc.b $bb ; #.###.##
                        dc.b $f3 ; ####..##
                        dc.b $f9 ; #####..#
                        dc.b $f7 ; ####.###
                        dc.b $ef ; ###.####
                        
BayShoreChar7c          dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c8 ; ##..#...
                        dc.b $9c ; #..###..
                        dc.b $3f ; ..######
                        
BayShoreChar7d          dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $70 ; .###....
                        dc.b $b8 ; #.###...
                        dc.b $ce ; ##..###.
                        
BayShoreChar7e          dc.b $ff ; ########
                        dc.b $50 ; .#.#....
                        dc.b $e5 ; ###..#.#
                        dc.b $fd ; ######.#
                        dc.b $fd ; ######.#
                        dc.b $9f ; #..#####
                        dc.b $3f ; ..######
                        dc.b $f8 ; #####...
                        
BayShoreChar7f          dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $e0 ; ###.....
                        dc.b $e0 ; ###.....
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayShoreChar80          dc.b $fa ; #####.#.
                        dc.b $eb ; ###.#.##
                        dc.b $ef ; ###.####
                        dc.b $ab ; #.#.#.##
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $7d ; .#####.#
                        dc.b $fd ; ######.#
                        
BayShoreChar81          dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
BayShoreChar82          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f0 ; ####....
                        
BayShoreChar83          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fe ; #######.
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        
BayShoreChar84          dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar85          dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $e0 ; ###.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
BayShoreChar86          dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
; -------------------------------------------------------------------------------------------------------------- ;
; Tank screen charset bridge
; -------------------------------------------------------------------------------------------------------------- ;
ScreenDataStrandBridge  dc.b $15 ; --> count
                        dc.b $ac ; --> BH_Scrn_GfxCharSets offset lo / $08
                        
StrandBridgeChar00      dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
StrandBridgeChar01      dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
StrandBridgeChar02      dc.b $0a ; ....#.#.
                        dc.b $05 ; .....#.#
                        dc.b $05 ; .....#.#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        dc.b $0f ; ....####
                        
StrandBridgeChar03      dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
StrandBridgeChar04      dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        
StrandBridgeChar05      dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $c0 ; ##......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
StrandBridgeChar06      dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
StrandBridgeChar07      dc.b $1f ; ...#####
                        dc.b $3f ; ..######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
StrandBridgeChar08      dc.b $aa ; #.#.#.#.
                        dc.b $55 ; .#.#.#.#
                        dc.b $55 ; .#.#.#.#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
StrandBridgeChar09      dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        dc.b $f0 ; ####....
                        dc.b $e0 ; ###.....
                        dc.b $c0 ; ##......
                        
StrandBridgeChar0a      dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $03 ; ......##
                        dc.b $03 ; ......##
                        
StrandBridgeChar0b      dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $fd ; ######.#
                        dc.b $f5 ; ####.#.#
                        dc.b $d5 ; ##.#.#.#
                        dc.b $f5 ; ####.#.#
                        dc.b $ff ; ########
                        
StrandBridgeChar0c      dc.b $c0 ; ##......
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $f8 ; #####...
                        dc.b $f8 ; #####...
                        
StrandBridgeChar0d      dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $1f ; ...#####
                        dc.b $1f ; ...#####
                        dc.b $0f ; ....####
                        dc.b $07 ; .....###
                        dc.b $01 ; .......#
                        
StrandBridgeChar0e      dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fc ; ######..
                        dc.b $fe ; #######.
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        
StrandBridgeChar0f      dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fe ; #######.
                        
StrandBridgeChar10      dc.b $fd ; ######.#
                        dc.b $f1 ; ####...#
                        dc.b $f5 ; ####.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $c5 ; ##...#.#
                        dc.b $f1 ; ####...#
                        dc.b $ff ; ########
                        
StrandBridgeChar11      dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        
StrandBridgeChar12      dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $fc ; ######..
                        dc.b $f8 ; #####...
                        dc.b $f5 ; ####.#.#
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $d5 ; ##.#.#.#
                        
StrandBridgeChar13      dc.b $5f ; .#.#####
                        dc.b $5f ; .#.#####
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $7e ; .######.
                        dc.b $7d ; .#####.#
                        
StrandBridgeChar14      dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $ff ; ########
                        dc.b $f3 ; ####..##
                        dc.b $f3 ; ####..##
                        dc.b $e3 ; ###...##
                        dc.b $e3 ; ###...##
                        dc.b $c3 ; ##....##
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatus           equ  *   ; 
TabTextStatusByBruce    equ  * - TabTextStatus
                        dc.b $02 ; b
                        dc.b $19 ; y
                        dc.b $20 ; _
                        dc.b $02 ; b
                        dc.b $12 ; r
                        dc.b $15 ; u
                        dc.b $03 ; c
                        dc.b $05 ; e
                        dc.b $20 ;  
                        dc.b $03 ; c
                        dc.b $01 ; a
                        dc.b $12 ; r
                        dc.b $16 ; v
                        dc.b $05 ; e
                        dc.b $12 ; r

TabTextStatusEndOfTxt   equ  * - TabTextStatus
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusCopyright  equ  * - TabTextStatus
                        dc.b $28 ; (
                        dc.b $03 ; c
                        dc.b $29 ; )
                        dc.b $20 ; _
                        dc.b $31 ; 1
                        dc.b $39 ; 9
                        dc.b $38 ; 8
                        dc.b $33 ; 3
                        dc.b $20 ; _
                        dc.b $20 ; _
                        dc.b $01 ; a
                        dc.b $03 ; c
                        dc.b $03 ; c
                        dc.b $05 ; e
                        dc.b $13 ; s
                        dc.b $13 ; s
                        dc.b $20 ; _
                        dc.b $13 ; s
                        dc.b $0f ; o
                        dc.b $06 ; f
                        dc.b $14 ; t
                        dc.b $17 ; w
                        dc.b $01 ; a
                        dc.b $12 ; r
                        dc.b $05 ; e
                        dc.b $20 ; _
                        dc.b $09 ; i
                        dc.b $0e ; n
                        dc.b $03 ; c
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusLevel      equ  * - TabTextStatus
                        dc.b $0c ; l
                        dc.b $05 ; e
                        dc.b $16 ; v
                        dc.b $05 ; e
                        dc.b $0c ; l
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusPlayer     equ  * - TabTextStatus
                        dc.b $10 ; p
                        dc.b $0c ; l
                        dc.b $01 ; a
                        dc.b $19 ; y
                        dc.b $05 ; e
                        dc.b $12 ; r
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusAmmo       equ  * - TabTextStatus
                        dc.b $01 ; a
                        dc.b $0d ; m
                        dc.b $0d ; m
                        dc.b $15 ; u
                        dc.b $0e ; n
                        dc.b $09 ; i
                        dc.b $14 ; t
                        dc.b $09 ; i
                        dc.b $0f ; o
                        dc.b $0e ; n
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatus40mm       equ  * - TabTextStatus
                        dc.b $34 ; 4
                        dc.b $30 ; 0
                        dc.b $0d ; m
                        dc.b $0d ; m
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatus250mm      equ  * - TabTextStatus
                        dc.b $32 ; 2
                        dc.b $35 ; 5
                        dc.b $30 ; 0
                        dc.b $0d ; m
                        dc.b $0d ; m
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatus104mm      equ  * - TabTextStatus
                        dc.b $31 ; 1
                        dc.b $30 ; 0
                        dc.b $34 ; 4
                        dc.b $0d ; m
                        dc.b $0d ; m
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusArialRec   equ  * - TabTextStatus
                        dc.b $01 ; a
                        dc.b $05 ; e
                        dc.b $12 ; r
                        dc.b $09 ; i
                        dc.b $01 ; a
                        dc.b $0c ; l
                        dc.b $20 ; _
                        dc.b $12 ; r
                        dc.b $05 ; e
                        dc.b $03 ; c
                        dc.b $0f ; o
                        dc.b $0e ; n
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusShips      equ  * - TabTextStatus
                        dc.b $13 ; s
                        dc.b $08 ; h
                        dc.b $09 ; i
                        dc.b $10 ; p
                        dc.b $13 ; s
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusTanks      equ  * - TabTextStatus
                        dc.b $14 ; t
                        dc.b $01 ; a
                        dc.b $0e ; n
                        dc.b $0b ; k
                        dc.b $13 ; s
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusGameOver   equ  * - TabTextStatus
                        dc.b $07 ; g
                        dc.b $01 ; a
                        dc.b $0d ; m
                        dc.b $05 ; e
                        dc.b $20 ; _
                        dc.b $0f ; o
A_be40                  dc.b $16 ; v
                        dc.b $05 ; e
                        dc.b $12 ; r
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusGetReady   equ  * - TabTextStatus
                        dc.b $07 ; g
                        dc.b $05 ; e
                        dc.b $14 ; t
                        dc.b $20 ; _
                        dc.b $12 ; r
                        dc.b $05 ; e
                        dc.b $01 ; a
                        dc.b $04 ; d
                        dc.b $19 ; y
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusPlayerOne  equ  * - TabTextStatus
                        dc.b $10 ; p
                        dc.b $0c ; l
A_be50                  dc.b $01 ; a
                        dc.b $19 ; y
                        dc.b $05 ; e
                        dc.b $12 ; r
                        dc.b $20 ; _
                        dc.b $0f ; o
                        dc.b $0e ; n
                        dc.b $05 ; e
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusPlayerTwo  equ  * - TabTextStatus
                        dc.b $10 ; p
                        dc.b $0c ; l
                        dc.b $01 ; a
                        dc.b $19 ; y
                        dc.b $05 ; e
                        dc.b $12 ; r
                        dc.b $20 ; _
A_be60                  dc.b $14 ; t
                        dc.b $17 ; w
                        dc.b $0f ; o
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusScore      equ  * - TabTextStatus
                        dc.b $13 ; s
                        dc.b $03 ; c
                        dc.b $0f ; o
                        dc.b $12 ; r
                        dc.b $05 ; e
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusDamage     equ  * - TabTextStatus
                        dc.b $04 ; d
                        dc.b $01 ; a
                        dc.b $0d ; m
                        dc.b $01 ; a
                        dc.b $07 ; g
                        dc.b $05 ; e
A_be70                  
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusDegElev    equ  * - TabTextStatus
                        dc.b $20 ; _
                        dc.b $20 ; _
                        dc.b $20 ; _
                        dc.b $04 ; d
                        dc.b $05 ; e
                        dc.b $07 ; g
                        dc.b $20 ; _
                        dc.b $05 ; e
                        dc.b $0c ; l
                        dc.b $05 ; e
                        dc.b $16 ; v
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusMLong      equ  * - TabTextStatus
                        dc.b $0d ; m
                        dc.b $20 ; _
                        dc.b $20 ; _
A_be80                  dc.b $20 ; _
                        dc.b $0c ; l
                        dc.b $0f ; o
                        dc.b $0e ; n
                        dc.b $07 ; g
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusMShort     equ  * - TabTextStatus
                        dc.b $0d ; m
                        dc.b $20 ; _
                        dc.b $20 ; _
                        dc.b $13 ; s
                        dc.b $08 ; h
                        dc.b $0f ; o
                        dc.b $12 ; r
                        dc.b $14 ; t
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusAmmoCube   equ  * - TabTextStatus
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        dc.b $7c ; 
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusClear      equ  * - TabTextStatus
                        dc.b $03 ; c
                        dc.b $0c ; l
                        dc.b $05 ; e
                        dc.b $01 ; a
                        dc.b $12 ; r
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusDirectHit  equ  * - TabTextStatus
                        dc.b $04 ; d
                        dc.b $09 ; i
                        dc.b $12 ; r
                        dc.b $05 ; e
                        dc.b $03 ; c
                        dc.b $14 ; t
                        dc.b $20 ; _
                        dc.b $08 ; h
                        dc.b $09 ; i
                        dc.b $14 ; t
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusShipDestr  equ  * - TabTextStatus
                        dc.b $13 ; s
                        dc.b $08 ; h
                        dc.b $09 ; i
                        dc.b $10 ; p
                        dc.b $20 ; _
                        dc.b $04 ; d
                        dc.b $05 ; e
                        dc.b $13 ; s
                        dc.b $14 ; t
                        dc.b $12 ; r
                        dc.b $0f ; o
                        dc.b $19 ; y
                        dc.b $05 ; e
                        dc.b $04 ; d
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
TabTextStatusShip       equ  * - TabTextStatus
                        dc.b $13 ; s
                        dc.b $08 ; h
                        dc.b $09 ; i
                        dc.b $10 ; p
                        dc.b $68 ; 
                        dc.b $68 ; 
J_bec0                  dc.b $58 ; 
                        dc.b $a9 ; 
                        dc.b $ff ; 
                        dc.b $85 ; 
                        dc.b $3a ; 
                        dc.b $4c ; 
                        dc.b $56 ; 
                        dc.b $a0 ; 
                        dc.b $20 ; 
                        dc.b $73 ; 
                        
                        dc.b $00 ; <end of text>
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $b0 ; 
                        dc.b $03 ; 
                        dc.b $4c ; 
                        dc.b $48 ; 
                        dc.b $a0 ; 
GR_bed0                 dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
T_bed3                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
GR_bed8                 dc.b $9e ; 
                        dc.b $bc ; 
                        dc.b $bc ; 
                        dc.b $bc ; 
GR_bedc                 dc.b $18 ; 
                        dc.b $30 ; 
                        dc.b $34 ; 
                        dc.b $38 ; 
GR_bee0                 dc.b $98 ; 
                        dc.b $b0 ; 
                        dc.b $b4 ; 
                        dc.b $b8 ; 
GR_bee4                 dc.b $1e ; 
                        dc.b $30 ; 
                        dc.b $34 ; 
                        dc.b $38 ; 
GR_bee8                 dc.b $14 ; 
                        dc.b $28 ; 
                        dc.b $2c ; 
                        dc.b $30 ; 
GR_beec                 dc.b $a0 ; 
                        dc.b $a0 ; 
                        dc.b $ac ; 
                        dc.b $b0 ; 
GR_bef0                 dc.b $1e ; 
                        dc.b $3c ; 
                        dc.b $3c ; 
                        dc.b $3c ; 
GR_bef4                 dc.b $8f ; 
                        dc.b $9e ; 
                        dc.b $9e ; 
                        dc.b $9e ; 
GR_bef8                 dc.b $0c ; 
                        dc.b $18 ; 
                        dc.b $1a ; 
                        dc.b $1c ; 
GR_befc                 dc.b $8c ; 
                        dc.b $98 ; 
                        dc.b $9a ; 
                        dc.b $9c ; 
GR_bf00                 dc.b $0a ; 
                        dc.b $0a ; 
                        dc.b $05 ; 
                        dc.b $02 ; 
GR_bf04                 dc.b $1e ; 
                        dc.b $28 ; 
                        dc.b $2d ; 
                        dc.b $32 ; 
GR_bf08                 dc.b $14 ; 
                        dc.b $0a ; 
                        dc.b $0a ; 
                        dc.b $0a ; 
GR_bf0c                 dc.b $04 ; 
                        dc.b $06 ; 
                        dc.b $0a ; 
                        dc.b $0a ; 
GR_bf10                 dc.b $05 ; 
                        dc.b $04 ; 
                        dc.b $03 ; 
                        dc.b $01 ; 
GR_bf14                 dc.b $40 ; 
                        dc.b $30 ; 
                        dc.b $20 ; 
                        dc.b $10 ; 
GR_bf18                 dc.b $ff ; 
                        dc.b $dc ; 
                        dc.b $b4 ; 
                        dc.b $78 ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        bne B_bf3c                  ; .hbu. - obsolete code
                        ldx #$e0                    ; 
                        cpx BHZ_b8                  ; 
                        bne B_bf3c                  ; 
                        jsr $b3d7                   ; 
                        jsr OPEN                    ; Kernel($FFC0) Open a logical file (via $31A to $F34A)
                        ldx #$e0                    ; 
                        jsr CHKOUT                  ; Kernel($FFC9) Define an output channel (via $320 to $F250)
                        bit $a008                   ; 
                        bmi B_bf39                  ; 
                        jsr $bb0b                   ; 
                        bne B_bf3c                  ; 
B_bf39                  jsr $bf01                   ; 
B_bf3c                  jsr $b68c                   ; 
                        ldx #$e0                    ; 
                        stx BHZ_b8                  ; 
                        jsr $b3d7                   ; 
                        lda #$02                    ; 
                        jmp $af3f                   ; 
                        lda #$b8                    ; 
                        ldy #$bf                    ; 
                        jsr $b373                   ; 
                        jsr $b3a8                   ; 
                        jsr $a03b                   ; 
                        lda BHZ_22                  ; 
                        sta BHZ_c1                  ; 
                        lda BHZ_23                  ; 
                        sta BHZ_c2                  ; 
                        jsr $ae6c                   ; not in this code
                        jsr $a03b                   ; 
                        lda BHZ_22                  ; 
                        ldx BHZ_23                  ; 
                        clc                         ; 
                        adc #$02                    ; 
                        sta BHZ_2d                  ; 
                        bcc B_bf72                  ; 
                        inx                         ; 
B_bf72                  stx BHZ_2e                  ; 
                        jsr $a03f                   ; 
                        jmp J_bec0                  ; 
                        lda $a003                   ; 
                        bne B_bf82                  ; 
                        jsr $a231                   ; 
B_bf82                  jsr BHZ_0079                ; 
                        lda #$00                    ; 
                        bcs B_bf94                  ; 
                        ldy #$01                    ; 
                        lda (BHZ_7a),y              ; 
                        cmp #$3a                    ; 
                        beq B_bf94                  ; 
                        jsr BHZ_0079                ; 
B_bf94                  jsr $a044                   ; 
                        jmp $a059                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_bf9a                  dc.b $0d ; 
                        dc.b $12 ; 
                        dc.b $44 ; d
                        dc.b $49 ; i
                        dc.b $53 ; s
                        dc.b $4b ; k
A_bfa0                  dc.b $3a ; 
                        dc.b $20 ; 
                        dc.b $00 ; 
                        dc.b $2d ; 
                        dc.b $20 ; 
                        dc.b $4d ; m
                        dc.b $45 ; e
                        dc.b $52 ; r
                        dc.b $47 ; g
                        dc.b $00 ; 
                        dc.b $2d ; 
                        dc.b $20 ; 
                        dc.b $4c ; l
                        dc.b $4f ; o
                        dc.b $41 ; a
                        dc.b $44 ; d
A_bfb0                  dc.b $00 ; 
                        dc.b $2d ; 
                        dc.b $20 ; 
                        dc.b $52 ; r
                        dc.b $45 ; e
                        dc.b $41 ; a
                        dc.b $44 ; d
                        dc.b $00 ; 
                        dc.b $41 ; a
                        dc.b $50 ; p
                        dc.b $50 ; p
                        dc.b $45 ; e
                        dc.b $4e ; n
                        dc.b $44 ; d
                        dc.b $00 ; 
                        dc.b $56 ; v
A_bfc0                  dc.b $45 ; e
                        dc.b $52 ; r
                        dc.b $49 ; i
                        dc.b $46 ; f
                        dc.b $59 ; y
                        dc.b $00 ; 
                        dc.b $49 ; i
                        dc.b $4e ; n
                        dc.b $47 ; g
                        dc.b $20 ; 
                        dc.b $2d ; 
                        dc.b $2d ; 
                        dc.b $2d ; 
                        dc.b $0d ; 
                        dc.b $00 ; 
                        dc.b $91 ; 
A_bfd0                  dc.b $56 ; v
                        dc.b $45 ; e
                        dc.b $52 ; r
                        dc.b $49 ; i
                        dc.b $46 ; f
                        dc.b $59 ; y
                        dc.b $20 ; 
                        dc.b $4f ; o
                        dc.b $4b ; k
                        dc.b $3a ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $20 ; 
                        dc.b $0d ; 
                        dc.b $00 ; 
                        dc.b $91 ; 
A_bfe0                  dc.b $12 ; 
                        dc.b $56 ; v
                        dc.b $45 ; e
                        dc.b $52 ; r
                        dc.b $49 ; i
                        dc.b $46 ; f
                        dc.b $59 ; y
                        dc.b $20 ; 
                        dc.b $45 ; e
                        dc.b $52 ; r
                        dc.b $52 ; r
                        dc.b $4f ; o
                        dc.b $52 ; r
                        dc.b $3a ; 
                        dc.b $0d ; 
                        dc.b $00 ; 
A_bff0                  dc.b $89 ; 
                        dc.b $6f ; O
                        dc.b $72 ; R
                        dc.b $9b ; 
                        dc.b $a7 ; 
                        dc.b $7f ; 
                        dc.b $04 ; 
                        dc.b $2d ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $3d ; 
                        dc.b $7f ; 
                        dc.b $00 ; 
                        dc.b $7f ; 
                        dc.b $84 ; 
                        dc.b $05 ; 
A_c000                  dc.b $00 ; 
                        dc.b $22 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
